/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class InExpression
implements Criterion {
    private final String propertyName;
    private final Object[] values;

    protected InExpression(String propertyName, Object[] values) {
        this.propertyName = propertyName;
        this.values = values;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        String singleValueParam = StringHelper.repeat("?, ", columns.length - 1) + "?";
        if (columns.length > 1) {
            singleValueParam = '(' + singleValueParam + ')';
        }
        String params = this.values.length > 0 ? StringHelper.repeat(singleValueParam + ", ", this.values.length - 1) + singleValueParam : "";
        String cols = StringHelper.join(", ", columns);
        if (columns.length > 1) {
            cols = '(' + cols + ')';
        }
        return cols + " in (" + params + ')';
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayList<TypedValue> list = new ArrayList<TypedValue>();
        Type type = criteriaQuery.getTypeUsingProjection(criteria, this.propertyName);
        if (type.isComponentType()) {
            AbstractComponentType actype = (AbstractComponentType)type;
            Type[] types = actype.getSubtypes();
            for (int i2 = 0; i2 < types.length; ++i2) {
                for (int j2 = 0; j2 < this.values.length; ++j2) {
                    Object subval = this.values[j2] == null ? null : actype.getPropertyValues(this.values[j2], EntityMode.POJO)[i2];
                    list.add(new TypedValue(types[i2], subval, EntityMode.POJO));
                }
            }
        } else {
            for (int j3 = 0; j3 < this.values.length; ++j3) {
                list.add(new TypedValue(type, this.values[j3], EntityMode.POJO));
            }
        }
        return list.toArray(new TypedValue[list.size()]);
    }

    public String toString() {
        return this.propertyName + " in (" + StringHelper.toString(this.values) + ')';
    }
}

