/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernate.util.StringHelper;

public class Junction
implements Criterion {
    private final List criteria = new ArrayList();
    private final String op;

    protected Junction(String op) {
        this.op = op;
    }

    public Junction add(Criterion criterion) {
        this.criteria.add(criterion);
        return this;
    }

    public String getOp() {
        return this.op;
    }

    public TypedValue[] getTypedValues(Criteria crit, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayList<TypedValue> typedValues = new ArrayList<TypedValue>();
        Iterator iter = this.criteria.iterator();
        while (iter.hasNext()) {
            TypedValue[] subvalues = ((Criterion)iter.next()).getTypedValues(crit, criteriaQuery);
            for (int i2 = 0; i2 < subvalues.length; ++i2) {
                typedValues.add(subvalues[i2]);
            }
        }
        return typedValues.toArray(new TypedValue[typedValues.size()]);
    }

    public String toSqlString(Criteria crit, CriteriaQuery criteriaQuery) throws HibernateException {
        if (this.criteria.size() == 0) {
            return "1=1";
        }
        StringBuffer buffer = new StringBuffer().append('(');
        Iterator iter = this.criteria.iterator();
        while (iter.hasNext()) {
            buffer.append(((Criterion)iter.next()).toSqlString(crit, criteriaQuery));
            if (!iter.hasNext()) continue;
            buffer.append(' ').append(this.op).append(' ');
        }
        return buffer.append(')').toString();
    }

    public String toString() {
        return '(' + StringHelper.join(' ' + this.op + ' ', this.criteria.iterator()) + ')';
    }
}

