/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class ProjectionList
implements Projection {
    private List elements = new ArrayList();

    protected ProjectionList() {
    }

    public ProjectionList create() {
        return new ProjectionList();
    }

    public ProjectionList add(Projection proj) {
        this.elements.add(proj);
        return this;
    }

    public ProjectionList add(Projection projection, String alias) {
        return this.add(Projections.alias(projection, alias));
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayList types = new ArrayList(this.getLength());
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            Object[] elemTypes = this.getProjection(i2).getTypes(criteria, criteriaQuery);
            ArrayHelper.addAll(types, elemTypes);
        }
        return ArrayHelper.toTypeArray(types);
    }

    public String toSqlString(Criteria criteria, int loc, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            Projection proj = this.getProjection(i2);
            buf.append(proj.toSqlString(criteria, loc, criteriaQuery));
            loc += proj.getColumnAliases(loc).length;
            if (i2 >= this.elements.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            Projection proj = this.getProjection(i2);
            if (!proj.isGrouped()) continue;
            buf.append(proj.toGroupSqlString(criteria, criteriaQuery)).append(", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    public String[] getColumnAliases(int loc) {
        ArrayList result = new ArrayList(this.getLength());
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            Object[] colAliases = this.getProjection(i2).getColumnAliases(loc);
            ArrayHelper.addAll(result, colAliases);
            loc += colAliases.length;
        }
        return ArrayHelper.toStringArray(result);
    }

    public String[] getColumnAliases(String alias, int loc) {
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            String[] result = this.getProjection(i2).getColumnAliases(alias, loc);
            if (result != null) {
                return result;
            }
            loc += this.getProjection(i2).getColumnAliases(loc).length;
        }
        return null;
    }

    public Type[] getTypes(String alias, Criteria criteria, CriteriaQuery criteriaQuery) {
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            Type[] result = this.getProjection(i2).getTypes(alias, criteria, criteriaQuery);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String[] getAliases() {
        ArrayList result = new ArrayList(this.getLength());
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            Object[] aliases = this.getProjection(i2).getAliases();
            ArrayHelper.addAll(result, aliases);
        }
        return ArrayHelper.toStringArray(result);
    }

    public Projection getProjection(int i2) {
        return (Projection)this.elements.get(i2);
    }

    public int getLength() {
        return this.elements.size();
    }

    public String toString() {
        return this.elements.toString();
    }

    public boolean isGrouped() {
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            if (!this.getProjection(i2).isGrouped()) continue;
            return true;
        }
        return false;
    }
}

