/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class SQLFunctionTemplate
implements SQLFunction {
    private final Type type;
    private final boolean hasArguments;
    private final boolean hasParenthesesIfNoArgs;
    private final String template;
    private final String[] chunks;
    private final int[] paramIndexes;

    public SQLFunctionTemplate(Type type, String template) {
        this(type, template, true);
    }

    public SQLFunctionTemplate(Type type, String template, boolean hasParenthesesIfNoArgs) {
        int i2;
        this.type = type;
        this.template = template;
        ArrayList<String> chunkList = new ArrayList<String>();
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        StringBuffer chunk = new StringBuffer(10);
        StringBuffer index = new StringBuffer(2);
        for (i2 = 0; i2 < template.length(); ++i2) {
            char c2 = template.charAt(i2);
            if (c2 == '?') {
                chunkList.add(chunk.toString());
                chunk.delete(0, chunk.length());
                while (++i2 < template.length()) {
                    c2 = template.charAt(i2);
                    if (Character.isDigit(c2)) {
                        index.append(c2);
                        continue;
                    }
                    chunk.append(c2);
                    break;
                }
                paramList.add(new Integer(Integer.parseInt(index.toString()) - 1));
                index.delete(0, index.length());
                continue;
            }
            chunk.append(c2);
        }
        if (chunk.length() > 0) {
            chunkList.add(chunk.toString());
        }
        this.chunks = chunkList.toArray(new String[chunkList.size()]);
        this.paramIndexes = new int[paramList.size()];
        for (i2 = 0; i2 < this.paramIndexes.length; ++i2) {
            this.paramIndexes[i2] = (Integer)paramList.get(i2);
        }
        this.hasArguments = this.paramIndexes.length > 0;
        this.hasParenthesesIfNoArgs = hasParenthesesIfNoArgs;
    }

    public String render(List args, SessionFactoryImplementor factory) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            if (i2 < this.paramIndexes.length) {
                Object arg;
                Object v0 = arg = this.paramIndexes[i2] < args.size() ? args.get(this.paramIndexes[i2]) : null;
                if (arg == null) continue;
                buf.append(this.chunks[i2]).append((Object)arg);
                continue;
            }
            buf.append(this.chunks[i2]);
        }
        return buf.toString();
    }

    public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
        return this.type;
    }

    public boolean hasArguments() {
        return this.hasArguments;
    }

    public boolean hasParenthesesIfNoArguments() {
        return this.hasParenthesesIfNoArgs;
    }

    public String toString() {
        return this.template;
    }
}

