/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.type.Type;

public class ParameterBinder {
    private static final Log log = LogFactory.getLog(ParameterBinder.class);

    private ParameterBinder() {
    }

    public static int bindQueryParameters(PreparedStatement st, QueryParameters queryParameters, int start, NamedParameterSource source, SessionImplementor session) throws SQLException, HibernateException {
        int col = start;
        col += ParameterBinder.bindPositionalParameters(st, queryParameters, col, session);
        col += ParameterBinder.bindNamedParameters(st, queryParameters, col, source, session);
        return col;
    }

    public static int bindPositionalParameters(PreparedStatement st, QueryParameters queryParameters, int start, SessionImplementor session) throws SQLException, HibernateException {
        return ParameterBinder.bindPositionalParameters(st, queryParameters.getPositionalParameterValues(), queryParameters.getPositionalParameterTypes(), start, session);
    }

    public static int bindPositionalParameters(PreparedStatement st, Object[] values, Type[] types, int start, SessionImplementor session) throws SQLException, HibernateException {
        int span = 0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            types[i2].nullSafeSet(st, values[i2], start + span, session);
            span += types[i2].getColumnSpan(session.getFactory());
        }
        return span;
    }

    public static int bindNamedParameters(PreparedStatement ps, QueryParameters queryParameters, int start, NamedParameterSource source, SessionImplementor session) throws SQLException, HibernateException {
        return ParameterBinder.bindNamedParameters(ps, queryParameters.getNamedParameters(), start, source, session);
    }

    public static int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, NamedParameterSource source, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e2 = iter.next();
                String name = (String)e2.getKey();
                TypedValue typedval = (TypedValue)e2.getValue();
                int[] locations = source.getNamedParameterLocations(name);
                for (int i2 = 0; i2 < locations.length; ++i2) {
                    if (log.isDebugEnabled()) {
                        log.debug("bindNamedParameters() " + typedval.getValue() + " -> " + name + " [" + (locations[i2] + start) + "]");
                    }
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locations[i2] + start, session);
                }
                result += locations.length;
            }
            return result;
        }
        return 0;
    }

    public static interface NamedParameterSource {
        public int[] getNamedParameterLocations(String var1);
    }
}

