/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.ScrollMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.pretty.Printer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public final class QueryParameters {
    private static final Log log = LogFactory.getLog(QueryParameters.class);
    private Type[] positionalParameterTypes;
    private Object[] positionalParameterValues;
    private Map namedParameters;
    private Map lockModes;
    private RowSelection rowSelection;
    private boolean cacheable;
    private String cacheRegion;
    private String comment;
    private ScrollMode scrollMode;
    private Serializable[] collectionKeys;
    private Object optionalObject;
    private String optionalEntityName;
    private Serializable optionalId;
    private boolean readOnly;
    private boolean callable = false;
    private boolean autodiscovertypes = false;
    private boolean isNaturalKeyLookup;
    private final ResultTransformer resultTransformer;
    private String processedSQL;
    private Type[] processedPositionalParameterTypes;
    private Object[] processedPositionalParameterValues;
    static /* synthetic */ Class class$java$util$Collection;

    public QueryParameters() {
        this(ArrayHelper.EMPTY_TYPE_ARRAY, ArrayHelper.EMPTY_OBJECT_ARRAY);
    }

    public QueryParameters(Type type, Object value) {
        this(new Type[]{type}, new Object[]{value});
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] postionalParameterValues, Object optionalObject, String optionalEntityName, Serializable optionalObjectId) {
        this(positionalParameterTypes, postionalParameterValues);
        this.optionalObject = optionalObject;
        this.optionalId = optionalObjectId;
        this.optionalEntityName = optionalEntityName;
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] postionalParameterValues) {
        this(positionalParameterTypes, postionalParameterValues, null, null, false, null, null, false, null);
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] postionalParameterValues, Serializable[] collectionKeys) {
        this(positionalParameterTypes, postionalParameterValues, null, collectionKeys);
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] postionalParameterValues, Map namedParameters, Serializable[] collectionKeys) {
        this(positionalParameterTypes, postionalParameterValues, namedParameters, null, null, false, false, null, null, collectionKeys, null);
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] positionalParameterValues, Map lockModes, RowSelection rowSelection, boolean cacheable, String cacheRegion, String comment, boolean isLookupByNaturalKey, ResultTransformer transformer) {
        this(positionalParameterTypes, positionalParameterValues, null, lockModes, rowSelection, false, cacheable, cacheRegion, comment, null, transformer);
        this.isNaturalKeyLookup = isLookupByNaturalKey;
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] positionalParameterValues, Map namedParameters, Map lockModes, RowSelection rowSelection, boolean readOnly, boolean cacheable, String cacheRegion, String comment, Serializable[] collectionKeys, ResultTransformer transformer) {
        this.positionalParameterTypes = positionalParameterTypes;
        this.positionalParameterValues = positionalParameterValues;
        this.namedParameters = namedParameters;
        this.lockModes = lockModes;
        this.rowSelection = rowSelection;
        this.cacheable = cacheable;
        this.cacheRegion = cacheRegion;
        this.comment = comment;
        this.collectionKeys = collectionKeys;
        this.readOnly = readOnly;
        this.resultTransformer = transformer;
    }

    public QueryParameters(Type[] positionalParameterTypes, Object[] positionalParameterValues, Map namedParameters, Map lockModes, RowSelection rowSelection, boolean readOnly, boolean cacheable, String cacheRegion, String comment, Serializable[] collectionKeys, Object optionalObject, String optionalEntityName, Serializable optionalId, ResultTransformer transformer) {
        this(positionalParameterTypes, positionalParameterValues, namedParameters, lockModes, rowSelection, readOnly, cacheable, cacheRegion, comment, collectionKeys, transformer);
        this.optionalEntityName = optionalEntityName;
        this.optionalId = optionalId;
        this.optionalObject = optionalObject;
    }

    public boolean hasRowSelection() {
        return this.rowSelection != null;
    }

    public Map getNamedParameters() {
        return this.namedParameters;
    }

    public Type[] getPositionalParameterTypes() {
        return this.positionalParameterTypes;
    }

    public Object[] getPositionalParameterValues() {
        return this.positionalParameterValues;
    }

    public RowSelection getRowSelection() {
        return this.rowSelection;
    }

    public ResultTransformer getResultTransformer() {
        return this.resultTransformer;
    }

    public void setNamedParameters(Map map) {
        this.namedParameters = map;
    }

    public void setPositionalParameterTypes(Type[] types) {
        this.positionalParameterTypes = types;
    }

    public void setPositionalParameterValues(Object[] objects) {
        this.positionalParameterValues = objects;
    }

    public void setRowSelection(RowSelection selection) {
        this.rowSelection = selection;
    }

    public Map getLockModes() {
        return this.lockModes;
    }

    public void setLockModes(Map map) {
        this.lockModes = map;
    }

    public void traceParameters(SessionFactoryImplementor factory) throws HibernateException {
        Printer print = new Printer(factory);
        if (this.positionalParameterValues.length != 0) {
            log.trace("parameters: " + print.toString(this.positionalParameterTypes, this.positionalParameterValues));
        }
        if (this.namedParameters != null) {
            log.trace("named parameters: " + print.toString(this.namedParameters));
        }
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean b2) {
        this.cacheable = b2;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public void setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
    }

    public void validateParameters() throws QueryException {
        int values;
        int types = this.positionalParameterTypes == null ? 0 : this.positionalParameterTypes.length;
        int n2 = values = this.positionalParameterValues == null ? 0 : this.positionalParameterValues.length;
        if (types != values) {
            throw new QueryException("Number of positional parameter types:" + types + " does not match number of positional parameters: " + values);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ScrollMode getScrollMode() {
        return this.scrollMode;
    }

    public void setScrollMode(ScrollMode scrollMode) {
        this.scrollMode = scrollMode;
    }

    public Serializable[] getCollectionKeys() {
        return this.collectionKeys;
    }

    public void setCollectionKeys(Serializable[] collectionKeys) {
        this.collectionKeys = collectionKeys;
    }

    public String getOptionalEntityName() {
        return this.optionalEntityName;
    }

    public void setOptionalEntityName(String optionalEntityName) {
        this.optionalEntityName = optionalEntityName;
    }

    public Serializable getOptionalId() {
        return this.optionalId;
    }

    public void setOptionalId(Serializable optionalId) {
        this.optionalId = optionalId;
    }

    public Object getOptionalObject() {
        return this.optionalObject;
    }

    public void setOptionalObject(Object optionalObject) {
        this.optionalObject = optionalObject;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setCallable(boolean callable) {
        this.callable = callable;
    }

    public boolean isCallable() {
        return this.callable;
    }

    public boolean hasAutoDiscoverScalarTypes() {
        return this.autodiscovertypes;
    }

    public void processFilters(String sql, SessionImplementor session) {
        if (session.getEnabledFilters().size() == 0 || sql.indexOf(":") < 0) {
            this.processedPositionalParameterValues = this.getPositionalParameterValues();
            this.processedPositionalParameterTypes = this.getPositionalParameterTypes();
            this.processedSQL = sql;
        } else {
            Dialect dialect = session.getFactory().getDialect();
            String symbols = " \n\r\f\t,()=<>&|+-=/*'^![]#~\\" + dialect.openQuote() + dialect.closeQuote();
            StringTokenizer tokens = new StringTokenizer(sql, symbols, true);
            StringBuffer result = new StringBuffer();
            ArrayList<Object> parameters = new ArrayList<Object>();
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (token.startsWith(":")) {
                    String filterParameterName = token.substring(1);
                    Object value = session.getFilterParameterValue(filterParameterName);
                    Type type = session.getFilterParameterType(filterParameterName);
                    if (value != null && (class$java$util$Collection == null ? QueryParameters.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(value.getClass())) {
                        Iterator itr = ((Collection)value).iterator();
                        while (itr.hasNext()) {
                            Object elementValue = itr.next();
                            result.append('?');
                            parameters.add(elementValue);
                            parameterTypes.add(type);
                            if (!itr.hasNext()) continue;
                            result.append(", ");
                        }
                        continue;
                    }
                    result.append('?');
                    parameters.add(value);
                    parameterTypes.add(type);
                    continue;
                }
                result.append(token);
            }
            parameters.addAll(Arrays.asList(this.getPositionalParameterValues()));
            parameterTypes.addAll(Arrays.asList(this.getPositionalParameterTypes()));
            this.processedPositionalParameterValues = parameters.toArray();
            this.processedPositionalParameterTypes = parameterTypes.toArray(new Type[0]);
            this.processedSQL = result.toString();
        }
    }

    public String getFilteredSQL() {
        return this.processedSQL;
    }

    public Object[] getFilteredPositionalParameterValues() {
        return this.processedPositionalParameterValues;
    }

    public Type[] getFilteredPositionalParameterTypes() {
        return this.processedPositionalParameterTypes;
    }

    public boolean isNaturalKeyLookup() {
        return this.isNaturalKeyLookup;
    }

    public void setNaturalKeyLookup(boolean isNaturalKeyLookup) {
        this.isNaturalKeyLookup = isNaturalKeyLookup;
    }

    public void setAutoDiscoverScalarTypes(boolean autodiscovertypes) {
        this.autodiscovertypes = autodiscovertypes;
    }

    public QueryParameters createCopyUsing(RowSelection selection) {
        QueryParameters copy = new QueryParameters(this.positionalParameterTypes, this.positionalParameterValues, this.namedParameters, this.lockModes, selection, this.readOnly, this.cacheable, this.cacheRegion, this.comment, this.collectionKeys, this.optionalObject, this.optionalEntityName, this.optionalId, this.resultTransformer);
        copy.processedSQL = this.processedSQL;
        copy.processedPositionalParameterTypes = this.processedPositionalParameterTypes;
        copy.processedPositionalParameterValues = this.processedPositionalParameterValues;
        return copy;
    }
}

