/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.EventSource;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.loader.custom.sql.SQLCustomQuery;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class NativeSQLQueryPlan
implements Serializable {
    private final String sourceQuery;
    private final SQLCustomQuery customQuery;
    private static final Log log = LogFactory.getLog(NativeSQLQueryPlan.class);

    public NativeSQLQueryPlan(NativeSQLQuerySpecification specification, SessionFactoryImplementor factory) {
        this.sourceQuery = specification.getQueryString();
        this.customQuery = new SQLCustomQuery(specification.getQueryString(), specification.getQueryReturns(), specification.getQuerySpaces(), factory);
    }

    public String getSourceQuery() {
        return this.sourceQuery;
    }

    public SQLCustomQuery getCustomQuery() {
        return this.customQuery;
    }

    private int[] getNamedParameterLocs(String name) throws QueryException {
        Object loc = this.customQuery.getNamedParameterBindPoints().get(name);
        if (loc == null) {
            throw new QueryException("Named parameter does not appear in Query: " + name, this.customQuery.getSQL());
        }
        if (loc instanceof Integer) {
            return new int[]{(Integer)loc};
        }
        return ArrayHelper.toIntArray((List)loc);
    }

    private int bindPositionalParameters(PreparedStatement st, QueryParameters queryParameters, int start, SessionImplementor session) throws SQLException, HibernateException {
        Object[] values = queryParameters.getFilteredPositionalParameterValues();
        Type[] types = queryParameters.getFilteredPositionalParameterTypes();
        int span = 0;
        for (int i2 = 0; i2 < values.length; ++i2) {
            types[i2].nullSafeSet(st, values[i2], start + span, session);
            span += types[i2].getColumnSpan(session.getFactory());
        }
        return span;
    }

    private int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException, HibernateException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                Map.Entry e2 = iter.next();
                String name = (String)e2.getKey();
                TypedValue typedval = (TypedValue)e2.getValue();
                int[] locs = this.getNamedParameterLocs(name);
                for (int i2 = 0; i2 < locs.length; ++i2) {
                    if (log.isDebugEnabled()) {
                        log.debug("bindNamedParameters() " + typedval.getValue() + " -> " + name + " [" + (locs[i2] + start) + "]");
                    }
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), locs[i2] + start, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor session) {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, this.getCustomQuery().getQuerySpaces());
        action.init();
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int performExecuteUpdate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        this.coordinateSharedCacheCleanup(session);
        if (queryParameters.isCallable()) {
            throw new IllegalArgumentException("callable not yet supported for native queries");
        }
        int result = 0;
        try {
            queryParameters.processFilters(this.customQuery.getSQL(), session);
            String sql = queryParameters.getFilteredSQL();
            PreparedStatement ps = session.getBatcher().prepareStatement(sql);
            try {
                int col = 1;
                col += this.bindPositionalParameters(ps, queryParameters, col, session);
                col += this.bindNamedParameters(ps, queryParameters.getNamedParameters(), col, session);
                result = ps.executeUpdate();
                Object var8_8 = null;
                if (ps == null) return result;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (ps == null) throw throwable;
                session.getBatcher().closeStatement(ps);
                throw throwable;
            }
            session.getBatcher().closeStatement(ps);
            return result;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not execute native bulk manipulation query", this.sourceQuery);
        }
    }
}

