/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.Initializable;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.def.DefaultAutoFlushEventListener;
import org.hibernate.event.def.DefaultDeleteEventListener;
import org.hibernate.event.def.DefaultDirtyCheckEventListener;
import org.hibernate.event.def.DefaultEvictEventListener;
import org.hibernate.event.def.DefaultFlushEntityEventListener;
import org.hibernate.event.def.DefaultFlushEventListener;
import org.hibernate.event.def.DefaultInitializeCollectionEventListener;
import org.hibernate.event.def.DefaultLoadEventListener;
import org.hibernate.event.def.DefaultLockEventListener;
import org.hibernate.event.def.DefaultMergeEventListener;
import org.hibernate.event.def.DefaultPersistEventListener;
import org.hibernate.event.def.DefaultPersistOnFlushEventListener;
import org.hibernate.event.def.DefaultPostLoadEventListener;
import org.hibernate.event.def.DefaultPreLoadEventListener;
import org.hibernate.event.def.DefaultRefreshEventListener;
import org.hibernate.event.def.DefaultReplicateEventListener;
import org.hibernate.event.def.DefaultSaveEventListener;
import org.hibernate.event.def.DefaultSaveOrUpdateCopyEventListener;
import org.hibernate.event.def.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.def.DefaultUpdateEventListener;
import org.hibernate.util.Cloneable;

public class EventListeners
extends Cloneable
implements Serializable {
    private LoadEventListener[] loadEventListeners = new LoadEventListener[]{new DefaultLoadEventListener()};
    private SaveOrUpdateEventListener[] saveOrUpdateEventListeners = new SaveOrUpdateEventListener[]{new DefaultSaveOrUpdateEventListener()};
    private MergeEventListener[] mergeEventListeners = new MergeEventListener[]{new DefaultMergeEventListener()};
    private PersistEventListener[] persistEventListeners = new PersistEventListener[]{new DefaultPersistEventListener()};
    private PersistEventListener[] persistOnFlushEventListeners = new PersistEventListener[]{new DefaultPersistOnFlushEventListener()};
    private ReplicateEventListener[] replicateEventListeners = new ReplicateEventListener[]{new DefaultReplicateEventListener()};
    private DeleteEventListener[] deleteEventListeners = new DeleteEventListener[]{new DefaultDeleteEventListener()};
    private AutoFlushEventListener[] autoFlushEventListeners = new AutoFlushEventListener[]{new DefaultAutoFlushEventListener()};
    private DirtyCheckEventListener[] dirtyCheckEventListeners = new DirtyCheckEventListener[]{new DefaultDirtyCheckEventListener()};
    private FlushEventListener[] flushEventListeners = new FlushEventListener[]{new DefaultFlushEventListener()};
    private EvictEventListener[] evictEventListeners = new EvictEventListener[]{new DefaultEvictEventListener()};
    private LockEventListener[] lockEventListeners = new LockEventListener[]{new DefaultLockEventListener()};
    private RefreshEventListener[] refreshEventListeners = new RefreshEventListener[]{new DefaultRefreshEventListener()};
    private FlushEntityEventListener[] flushEntityEventListeners = new FlushEntityEventListener[]{new DefaultFlushEntityEventListener()};
    private InitializeCollectionEventListener[] initializeCollectionEventListeners = new InitializeCollectionEventListener[]{new DefaultInitializeCollectionEventListener()};
    private PostLoadEventListener[] postLoadEventListeners = new PostLoadEventListener[]{new DefaultPostLoadEventListener()};
    private PreLoadEventListener[] preLoadEventListeners = new PreLoadEventListener[]{new DefaultPreLoadEventListener()};
    private PreDeleteEventListener[] preDeleteEventListeners = new PreDeleteEventListener[0];
    private PreUpdateEventListener[] preUpdateEventListeners = new PreUpdateEventListener[0];
    private PreInsertEventListener[] preInsertEventListeners = new PreInsertEventListener[0];
    private PostDeleteEventListener[] postDeleteEventListeners = new PostDeleteEventListener[0];
    private PostUpdateEventListener[] postUpdateEventListeners = new PostUpdateEventListener[0];
    private PostInsertEventListener[] postInsertEventListeners = new PostInsertEventListener[0];
    private PostDeleteEventListener[] postCommitDeleteEventListeners = new PostDeleteEventListener[0];
    private PostUpdateEventListener[] postCommitUpdateEventListeners = new PostUpdateEventListener[0];
    private PostInsertEventListener[] postCommitInsertEventListeners = new PostInsertEventListener[0];
    private SaveOrUpdateEventListener[] saveEventListeners = new SaveOrUpdateEventListener[]{new DefaultSaveEventListener()};
    private SaveOrUpdateEventListener[] updateEventListeners = new SaveOrUpdateEventListener[]{new DefaultUpdateEventListener()};
    private MergeEventListener[] saveOrUpdateCopyEventListeners = new MergeEventListener[]{new DefaultSaveOrUpdateCopyEventListener()};
    private static Map eventInterfaceFromType = new HashMap();

    public Class getListenerClassFor(String type) {
        Class clazz = (Class)eventInterfaceFromType.get(type);
        if (clazz == null) {
            throw new MappingException("Unrecognized listener type [" + type + "]");
        }
        return clazz;
    }

    public LoadEventListener[] getLoadEventListeners() {
        return this.loadEventListeners;
    }

    public void setLoadEventListeners(LoadEventListener[] loadEventListener) {
        this.loadEventListeners = loadEventListener;
    }

    public ReplicateEventListener[] getReplicateEventListeners() {
        return this.replicateEventListeners;
    }

    public void setReplicateEventListeners(ReplicateEventListener[] replicateEventListener) {
        this.replicateEventListeners = replicateEventListener;
    }

    public DeleteEventListener[] getDeleteEventListeners() {
        return this.deleteEventListeners;
    }

    public void setDeleteEventListeners(DeleteEventListener[] deleteEventListener) {
        this.deleteEventListeners = deleteEventListener;
    }

    public AutoFlushEventListener[] getAutoFlushEventListeners() {
        return this.autoFlushEventListeners;
    }

    public void setAutoFlushEventListeners(AutoFlushEventListener[] autoFlushEventListener) {
        this.autoFlushEventListeners = autoFlushEventListener;
    }

    public DirtyCheckEventListener[] getDirtyCheckEventListeners() {
        return this.dirtyCheckEventListeners;
    }

    public void setDirtyCheckEventListeners(DirtyCheckEventListener[] dirtyCheckEventListener) {
        this.dirtyCheckEventListeners = dirtyCheckEventListener;
    }

    public FlushEventListener[] getFlushEventListeners() {
        return this.flushEventListeners;
    }

    public void setFlushEventListeners(FlushEventListener[] flushEventListener) {
        this.flushEventListeners = flushEventListener;
    }

    public EvictEventListener[] getEvictEventListeners() {
        return this.evictEventListeners;
    }

    public void setEvictEventListeners(EvictEventListener[] evictEventListener) {
        this.evictEventListeners = evictEventListener;
    }

    public LockEventListener[] getLockEventListeners() {
        return this.lockEventListeners;
    }

    public void setLockEventListeners(LockEventListener[] lockEventListener) {
        this.lockEventListeners = lockEventListener;
    }

    public RefreshEventListener[] getRefreshEventListeners() {
        return this.refreshEventListeners;
    }

    public void setRefreshEventListeners(RefreshEventListener[] refreshEventListener) {
        this.refreshEventListeners = refreshEventListener;
    }

    public InitializeCollectionEventListener[] getInitializeCollectionEventListeners() {
        return this.initializeCollectionEventListeners;
    }

    public void setInitializeCollectionEventListeners(InitializeCollectionEventListener[] initializeCollectionEventListener) {
        this.initializeCollectionEventListeners = initializeCollectionEventListener;
    }

    public FlushEntityEventListener[] getFlushEntityEventListeners() {
        return this.flushEntityEventListeners;
    }

    public void setFlushEntityEventListeners(FlushEntityEventListener[] flushEntityEventListener) {
        this.flushEntityEventListeners = flushEntityEventListener;
    }

    public SaveOrUpdateEventListener[] getSaveOrUpdateEventListeners() {
        return this.saveOrUpdateEventListeners;
    }

    public void setSaveOrUpdateEventListeners(SaveOrUpdateEventListener[] saveOrUpdateEventListener) {
        this.saveOrUpdateEventListeners = saveOrUpdateEventListener;
    }

    public MergeEventListener[] getMergeEventListeners() {
        return this.mergeEventListeners;
    }

    public void setMergeEventListeners(MergeEventListener[] mergeEventListener) {
        this.mergeEventListeners = mergeEventListener;
    }

    public PersistEventListener[] getPersistEventListeners() {
        return this.persistEventListeners;
    }

    public void setPersistEventListeners(PersistEventListener[] createEventListener) {
        this.persistEventListeners = createEventListener;
    }

    public PersistEventListener[] getPersistOnFlushEventListeners() {
        return this.persistOnFlushEventListeners;
    }

    public void setPersistOnFlushEventListeners(PersistEventListener[] createEventListener) {
        this.persistOnFlushEventListeners = createEventListener;
    }

    public MergeEventListener[] getSaveOrUpdateCopyEventListeners() {
        return this.saveOrUpdateCopyEventListeners;
    }

    public void setSaveOrUpdateCopyEventListeners(MergeEventListener[] saveOrUpdateCopyEventListener) {
        this.saveOrUpdateCopyEventListeners = saveOrUpdateCopyEventListener;
    }

    public SaveOrUpdateEventListener[] getSaveEventListeners() {
        return this.saveEventListeners;
    }

    public void setSaveEventListeners(SaveOrUpdateEventListener[] saveEventListener) {
        this.saveEventListeners = saveEventListener;
    }

    public SaveOrUpdateEventListener[] getUpdateEventListeners() {
        return this.updateEventListeners;
    }

    public void setUpdateEventListeners(SaveOrUpdateEventListener[] updateEventListener) {
        this.updateEventListeners = updateEventListener;
    }

    public PostLoadEventListener[] getPostLoadEventListeners() {
        return this.postLoadEventListeners;
    }

    public void setPostLoadEventListeners(PostLoadEventListener[] postLoadEventListener) {
        this.postLoadEventListeners = postLoadEventListener;
    }

    public PreLoadEventListener[] getPreLoadEventListeners() {
        return this.preLoadEventListeners;
    }

    public void setPreLoadEventListeners(PreLoadEventListener[] preLoadEventListener) {
        this.preLoadEventListeners = preLoadEventListener;
    }

    public PostDeleteEventListener[] getPostDeleteEventListeners() {
        return this.postDeleteEventListeners;
    }

    public PostInsertEventListener[] getPostInsertEventListeners() {
        return this.postInsertEventListeners;
    }

    public PostUpdateEventListener[] getPostUpdateEventListeners() {
        return this.postUpdateEventListeners;
    }

    public void setPostDeleteEventListeners(PostDeleteEventListener[] postDeleteEventListener) {
        this.postDeleteEventListeners = postDeleteEventListener;
    }

    public void setPostInsertEventListeners(PostInsertEventListener[] postInsertEventListener) {
        this.postInsertEventListeners = postInsertEventListener;
    }

    public void setPostUpdateEventListeners(PostUpdateEventListener[] postUpdateEventListener) {
        this.postUpdateEventListeners = postUpdateEventListener;
    }

    public PreDeleteEventListener[] getPreDeleteEventListeners() {
        return this.preDeleteEventListeners;
    }

    public void setPreDeleteEventListeners(PreDeleteEventListener[] preDeleteEventListener) {
        this.preDeleteEventListeners = preDeleteEventListener;
    }

    public PreInsertEventListener[] getPreInsertEventListeners() {
        return this.preInsertEventListeners;
    }

    public void setPreInsertEventListeners(PreInsertEventListener[] preInsertEventListener) {
        this.preInsertEventListeners = preInsertEventListener;
    }

    public PreUpdateEventListener[] getPreUpdateEventListeners() {
        return this.preUpdateEventListeners;
    }

    public void setPreUpdateEventListeners(PreUpdateEventListener[] preUpdateEventListener) {
        this.preUpdateEventListeners = preUpdateEventListener;
    }

    public void initializeListeners(Configuration cfg) {
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Object[] listeners;
            try {
                Object listener = fields[i2].get(this);
                if (!(listener instanceof Object[])) continue;
                listeners = (Object[])listener;
            }
            catch (Exception e2) {
                throw new AssertionFailure("could not init listeners");
            }
            int length = listeners.length;
            for (int index = 0; index < length; ++index) {
                Object listener = listeners[index];
                if (!(listener instanceof Initializable)) continue;
                ((Initializable)listener).initialize(cfg);
            }
        }
    }

    public PostDeleteEventListener[] getPostCommitDeleteEventListeners() {
        return this.postCommitDeleteEventListeners;
    }

    public void setPostCommitDeleteEventListeners(PostDeleteEventListener[] postCommitDeleteEventListeners) {
        this.postCommitDeleteEventListeners = postCommitDeleteEventListeners;
    }

    public PostInsertEventListener[] getPostCommitInsertEventListeners() {
        return this.postCommitInsertEventListeners;
    }

    public void setPostCommitInsertEventListeners(PostInsertEventListener[] postCommitInsertEventListeners) {
        this.postCommitInsertEventListeners = postCommitInsertEventListeners;
    }

    public PostUpdateEventListener[] getPostCommitUpdateEventListeners() {
        return this.postCommitUpdateEventListeners;
    }

    public void setPostCommitUpdateEventListeners(PostUpdateEventListener[] postCommitUpdateEventListeners) {
        this.postCommitUpdateEventListeners = postCommitUpdateEventListeners;
    }

    static {
        eventInterfaceFromType.put("auto-flush", AutoFlushEventListener.class);
        eventInterfaceFromType.put("merge", MergeEventListener.class);
        eventInterfaceFromType.put("create", PersistEventListener.class);
        eventInterfaceFromType.put("create-onflush", PersistEventListener.class);
        eventInterfaceFromType.put("delete", DeleteEventListener.class);
        eventInterfaceFromType.put("dirty-check", DirtyCheckEventListener.class);
        eventInterfaceFromType.put("evict", EvictEventListener.class);
        eventInterfaceFromType.put("flush", FlushEventListener.class);
        eventInterfaceFromType.put("flush-entity", FlushEntityEventListener.class);
        eventInterfaceFromType.put("load", LoadEventListener.class);
        eventInterfaceFromType.put("load-collection", InitializeCollectionEventListener.class);
        eventInterfaceFromType.put("lock", LockEventListener.class);
        eventInterfaceFromType.put("refresh", RefreshEventListener.class);
        eventInterfaceFromType.put("replicate", ReplicateEventListener.class);
        eventInterfaceFromType.put("save-update", SaveOrUpdateEventListener.class);
        eventInterfaceFromType.put("save", SaveOrUpdateEventListener.class);
        eventInterfaceFromType.put("update", SaveOrUpdateEventListener.class);
        eventInterfaceFromType.put("pre-load", PreLoadEventListener.class);
        eventInterfaceFromType.put("pre-update", PreUpdateEventListener.class);
        eventInterfaceFromType.put("pre-delete", PreDeleteEventListener.class);
        eventInterfaceFromType.put("pre-insert", PreInsertEventListener.class);
        eventInterfaceFromType.put("post-load", PostLoadEventListener.class);
        eventInterfaceFromType.put("post-update", PostUpdateEventListener.class);
        eventInterfaceFromType.put("post-delete", PostDeleteEventListener.class);
        eventInterfaceFromType.put("post-insert", PostInsertEventListener.class);
        eventInterfaceFromType.put("post-commit-update", PostUpdateEventListener.class);
        eventInterfaceFromType.put("post-commit-delete", PostDeleteEventListener.class);
        eventInterfaceFromType.put("post-commit-insert", PostInsertEventListener.class);
        eventInterfaceFromType = Collections.unmodifiableMap(eventInterfaceFromType);
    }
}

