/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.event.EventSource;
import org.hibernate.event.EvictEvent;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.def.EvictVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class DefaultEvictEventListener
implements EvictEventListener {
    private static final Log log = LogFactory.getLog(DefaultEvictEventListener.class);

    public void onEvict(EvictEvent event) throws HibernateException {
        EventSource source = event.getSession();
        Object object = event.getObject();
        PersistenceContext persistenceContext = source.getPersistenceContext();
        if (object instanceof HibernateProxy) {
            Object entity;
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            Serializable id = li.getIdentifier();
            EntityPersister persister = source.getFactory().getEntityPersister(li.getEntityName());
            if (id == null) {
                throw new IllegalArgumentException("null identifier");
            }
            EntityKey key = new EntityKey(id, persister, source.getEntityMode());
            persistenceContext.removeProxy(key);
            if (!li.isUninitialized() && (entity = persistenceContext.removeEntity(key)) != null) {
                EntityEntry e2 = event.getSession().getPersistenceContext().removeEntry(entity);
                this.doEvict(entity, key, e2.getPersister(), event.getSession());
            }
            li.setSession(null);
        } else {
            EntityEntry e3 = persistenceContext.removeEntry(object);
            if (e3 != null) {
                EntityKey key = new EntityKey(e3.getId(), e3.getPersister(), source.getEntityMode());
                persistenceContext.removeEntity(key);
                this.doEvict(object, key, e3.getPersister(), source);
            }
        }
    }

    protected void doEvict(Object object, EntityKey key, EntityPersister persister, EventSource session) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("evicting " + MessageHelper.infoString(persister));
        }
        if (persister.hasCollections()) {
            new EvictVisitor(session).process(object, persister);
        }
        new Cascade(CascadingAction.EVICT, 0, session).cascade(persister, object);
    }
}

