/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractVisitor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;

public class EvictVisitor
extends AbstractVisitor {
    private static final Log log = LogFactory.getLog(EvictVisitor.class);

    EvictVisitor(EventSource session) {
        super(session);
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            this.evictCollection(collection, type);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void evictCollection(Object value, CollectionType type) {
        void var3_3;
        Object pc;
        if (type.hasHolder(this.getSession().getEntityMode())) {
            pc = this.getSession().getPersistenceContext().removeCollectionHolder(value);
        } else if (value instanceof PersistentCollection) {
            pc = value;
        } else {
            return;
        }
        PersistentCollection collection = (PersistentCollection)var3_3;
        if (collection.unsetSession(this.getSession())) {
            this.evictCollection(collection);
        }
    }

    private void evictCollection(PersistentCollection collection) {
        CollectionEntry ce = (CollectionEntry)this.getSession().getPersistenceContext().getCollectionEntries().remove(collection);
        if (log.isDebugEnabled()) {
            log.debug("evicting collection: " + MessageHelper.collectionInfoString(ce.getLoadedPersister(), ce.getLoadedKey(), this.getSession().getFactory()));
        }
        if (ce.getLoadedPersister() != null && ce.getLoadedKey() != null) {
            this.getSession().getPersistenceContext().getCollectionsByKey().remove(new CollectionKey(ce.getLoadedPersister(), ce.getLoadedKey(), this.getSession().getEntityMode()));
        }
    }
}

