/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.RecognitionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.QuerySyntaxException;

public class ErrorCounter
implements ParseErrorHandler {
    private Log log = LogFactory.getLog(ErrorCounter.class);
    private Log hqlLog = LogFactory.getLog("org.hibernate.hql.PARSER");
    private List errorList = new ArrayList();
    private List warningList = new ArrayList();
    private List recognitionExceptions = new ArrayList();

    public void reportError(RecognitionException e2) {
        this.reportError(e2.toString());
        this.recognitionExceptions.add(e2);
        if (this.log.isDebugEnabled()) {
            this.log.debug(e2, e2);
        }
    }

    public void reportError(String message) {
        this.hqlLog.error(message);
        this.errorList.add(message);
    }

    public int getErrorCount() {
        return this.errorList.size();
    }

    public void reportWarning(String message) {
        this.hqlLog.debug(message);
        this.warningList.add(message);
    }

    private String getErrorString() {
        StringBuffer buf = new StringBuffer();
        Iterator iterator = this.errorList.iterator();
        while (iterator.hasNext()) {
            buf.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    public void throwQueryException() throws QueryException {
        if (this.getErrorCount() > 0) {
            if (this.recognitionExceptions.size() > 0) {
                throw QuerySyntaxException.convert((RecognitionException)this.recognitionExceptions.get(0));
            }
            throw new QueryException(this.getErrorString());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("throwQueryException() : no errors");
        }
    }
}

