/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.antlr.SqlGeneratorBase;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.ErrorReporter;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.MethodNode;
import org.hibernate.hql.ast.tree.Node;

public class SqlGenerator
extends SqlGeneratorBase
implements ErrorReporter {
    private ParseErrorHandler parseErrorHandler;
    private SqlWriter writer = new DefaultWriter();
    private SessionFactoryImplementor sessionFactory;
    private LinkedList outputStack = new LinkedList();

    protected void out(String s) {
        this.writer.clause(s);
    }

    protected void out(AST n2) {
        if (n2 instanceof Node) {
            this.out(((Node)n2).getRenderText(this.sessionFactory));
        } else {
            super.out(n2);
        }
    }

    protected void commaBetweenParameters(String comma) {
        this.writer.commaBetweenParameters(comma);
    }

    public void reportError(RecognitionException e2) {
        this.parseErrorHandler.reportError(e2);
    }

    public void reportError(String s) {
        this.parseErrorHandler.reportError(s);
    }

    public void reportWarning(String s) {
        this.parseErrorHandler.reportWarning(s);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public SqlGenerator(SessionFactoryImplementor sfi) {
        this.parseErrorHandler = new ErrorCounter();
        this.sessionFactory = sfi;
    }

    public String getSQL() {
        return this.getStringBuffer().toString();
    }

    protected void optionalSpace() {
        int c2 = this.getLastChar();
        switch (c2) {
            case -1: {
                return;
            }
            case 32: {
                return;
            }
            case 41: {
                return;
            }
            case 40: {
                return;
            }
        }
        this.out(" ");
    }

    protected void beginFunctionTemplate(AST m2, AST i2) {
        MethodNode methodNode = (MethodNode)m2;
        SQLFunction template = methodNode.getSQLFunction();
        if (template == null) {
            super.beginFunctionTemplate(m2, i2);
        } else {
            this.outputStack.addFirst(this.writer);
            this.writer = new FunctionArguments();
        }
    }

    protected void endFunctionTemplate(AST m2) {
        MethodNode methodNode = (MethodNode)m2;
        SQLFunction template = methodNode.getSQLFunction();
        if (template == null) {
            super.endFunctionTemplate(m2);
        } else {
            FunctionArguments functionArguments = (FunctionArguments)this.writer;
            this.writer = (SqlWriter)this.outputStack.removeFirst();
            this.out(template.render(functionArguments.getArgs(), this.sessionFactory));
        }
    }

    public static void panic() {
        throw new QueryException("TreeWalker: panic");
    }

    protected void fromFragmentSeparator(AST a2) {
        FromElement right;
        AST next = a2.getNextSibling();
        if (next == null || !this.hasText(a2)) {
            return;
        }
        FromElement left = (FromElement)a2;
        for (right = (FromElement)next; right != null && !this.hasText(right); right = (FromElement)right.getNextSibling()) {
        }
        if (right == null) {
            return;
        }
        if (!this.hasText(right)) {
            return;
        }
        if (right.getRealOrigin() == left || right.getRealOrigin() != null && right.getRealOrigin() == left.getRealOrigin()) {
            if (right.getJoinSequence() != null && right.getJoinSequence().isThetaStyle()) {
                this.out(", ");
            } else {
                this.out(" ");
            }
        } else {
            this.out(", ");
        }
    }

    protected void nestedFromFragment(AST d2, AST parent) {
        if (d2 != null && this.hasText(d2)) {
            if (parent != null && this.hasText(parent)) {
                FromElement left = (FromElement)parent;
                FromElement right = (FromElement)d2;
                if (right.getRealOrigin() == left) {
                    if (right.getJoinSequence() != null && right.getJoinSequence().isThetaStyle()) {
                        this.out(", ");
                    } else {
                        this.out(" ");
                    }
                } else {
                    this.out(", ");
                }
            }
            this.out(d2);
        }
    }

    class DefaultWriter
    implements SqlWriter {
        DefaultWriter() {
        }

        public void clause(String clause) {
            SqlGenerator.this.getStringBuffer().append(clause);
        }

        public void commaBetweenParameters(String comma) {
            SqlGenerator.this.getStringBuffer().append(comma);
        }
    }

    class FunctionArguments
    implements SqlWriter {
        private int argInd;
        private final List args = new ArrayList(3);

        FunctionArguments() {
        }

        public void clause(String clause) {
            if (this.argInd == this.args.size()) {
                this.args.add(clause);
            } else {
                this.args.set(this.argInd, this.args.get(this.argInd) + clause);
            }
        }

        public void commaBetweenParameters(String comma) {
            ++this.argInd;
        }

        public List getArgs() {
            return this.args;
        }
    }

    static interface SqlWriter {
        public void clause(String var1);

        public void commaBetweenParameters(String var1);
    }
}

