/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.hql.ast.DetailedSemanticException;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.PathNode;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.SelectExpressionList;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class ConstructorNode
extends SelectExpressionList
implements SelectExpression {
    private Constructor constructor;
    private Type[] constructorArgumentTypes;
    private boolean isMap;
    private boolean isList;

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isList() {
        return this.isList;
    }

    public String[] getAliases() {
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        String[] aliases = new String[selectExpressions.length];
        for (int i2 = 0; i2 < selectExpressions.length; ++i2) {
            String alias = selectExpressions[i2].getAlias();
            aliases[i2] = alias == null ? Integer.toString(i2) : alias;
        }
        return aliases;
    }

    public void setScalarColumnText(int i2) throws SemanticException {
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        for (int j2 = 0; j2 < selectExpressions.length; ++j2) {
            SelectExpression selectExpression = selectExpressions[j2];
            selectExpression.setScalarColumnText(j2);
        }
    }

    protected AST getFirstSelectExpression() {
        return this.getFirstChild().getNextSibling();
    }

    public Type getDataType() {
        throw new UnsupportedOperationException("getDataType() is not supported by ConstructorNode!");
    }

    public void prepare() throws SemanticException {
        this.constructorArgumentTypes = this.resolveConstructorArgumentTypes();
        String path = ((PathNode)((Object)this.getFirstChild())).getPath();
        if ("map".equals(path.toLowerCase())) {
            this.isMap = true;
        } else if ("list".equals(path.toLowerCase())) {
            this.isList = true;
        } else {
            this.constructor = this.resolveConstructor(path);
        }
    }

    private Type[] resolveConstructorArgumentTypes() throws SemanticException {
        SelectExpression[] argumentExpressions = this.collectSelectExpressions();
        if (argumentExpressions == null) {
            return new Type[0];
        }
        Type[] types = new Type[argumentExpressions.length];
        for (int x = 0; x < argumentExpressions.length; ++x) {
            types[x] = argumentExpressions[x].getDataType();
        }
        return types;
    }

    private Constructor resolveConstructor(String path) throws SemanticException {
        String className;
        String importedClassName = this.getSessionFactoryHelper().getImportedClassName(path);
        String string = className = StringHelper.isEmpty(importedClassName) ? path : importedClassName;
        if (className == null) {
            throw new SemanticException("Unable to locate class [" + path + "]");
        }
        try {
            Class holderClass = ReflectHelper.classForName(className);
            return ReflectHelper.getConstructor(holderClass, this.constructorArgumentTypes);
        }
        catch (ClassNotFoundException e2) {
            throw new DetailedSemanticException("Unable to locate class [" + className + "]", e2);
        }
        catch (PropertyNotFoundException e3) {
            throw new DetailedSemanticException("Unable to locate appropriate constructor on class [" + className + "]", e3);
        }
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public List getConstructorArgumentTypeList() {
        return Arrays.asList(this.constructorArgumentTypes);
    }

    public FromElement getFromElement() {
        return null;
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isReturnableEntity() throws SemanticException {
        return false;
    }

    public boolean isScalar() {
        return true;
    }

    public void setAlias(String alias) {
        throw new UnsupportedOperationException("constructor may not be aliased");
    }

    public String getAlias() {
        throw new UnsupportedOperationException("constructor may not be aliased");
    }
}

