/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.InitializeableNode;
import org.hibernate.hql.ast.tree.PathNode;
import org.hibernate.hql.ast.tree.ResolvableNode;

public abstract class FromReferenceNode
extends AbstractSelectExpression
implements ResolvableNode,
DisplayableNode,
InitializeableNode,
PathNode {
    private static final Log log = LogFactory.getLog(FromReferenceNode.class);
    private FromElement fromElement;
    private boolean resolved = false;
    public static final int ROOT_LEVEL = 0;

    public FromElement getFromElement() {
        return this.fromElement;
    }

    public void setFromElement(FromElement fromElement) {
        this.fromElement = fromElement;
    }

    public void resolveFirstChild() throws SemanticException {
    }

    public String getPath() {
        return this.getOriginalText();
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved() {
        this.resolved = true;
        if (log.isDebugEnabled()) {
            log.debug("Resolved :  " + this.getPath() + " -> " + this.getText());
        }
    }

    public String getDisplayText() {
        StringBuffer buf = new StringBuffer();
        buf.append("{").append(this.fromElement == null ? "no fromElement" : this.fromElement.getDisplayText());
        buf.append("}");
        return buf.toString();
    }

    public void recursiveResolve(int level, boolean impliedAtRoot, String classAlias) throws SemanticException {
        this.recursiveResolve(level, impliedAtRoot, classAlias, this);
    }

    public void recursiveResolve(int level, boolean impliedAtRoot, String classAlias, AST parent) throws SemanticException {
        AST lhs = this.getFirstChild();
        int nextLevel = level + 1;
        if (lhs != null) {
            FromReferenceNode n2 = (FromReferenceNode)lhs;
            n2.recursiveResolve(nextLevel, impliedAtRoot, null, this);
        }
        this.resolveFirstChild();
        boolean impliedJoin = true;
        if (level == 0 && !impliedAtRoot) {
            impliedJoin = false;
        }
        this.resolve(true, impliedJoin, classAlias, parent);
    }

    public boolean isReturnableEntity() throws SemanticException {
        return !this.isScalar() && this.fromElement.isEntity();
    }

    public void resolveInFunctionCall(boolean generateJoin, boolean implicitJoin) throws SemanticException {
        this.resolve(generateJoin, implicitJoin);
    }

    public void resolve(boolean generateJoin, boolean implicitJoin) throws SemanticException {
        this.resolve(generateJoin, implicitJoin, null);
    }

    public void resolve(boolean generateJoin, boolean implicitJoin, String classAlias) throws SemanticException {
        this.resolve(generateJoin, implicitJoin, classAlias, null);
    }

    public void prepareForDot(String propertyName) throws SemanticException {
    }

    public FromElement getImpliedJoin() {
        return null;
    }
}

