/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.collections.AST;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.util.StringHelper;

public class ASTPrinter {
    private Map tokenTypeNamesByTokenType;
    private Class tokenTypeConstants;
    private boolean showClassNames = true;

    public ASTPrinter(Class tokenTypeConstants) {
        this.tokenTypeConstants = tokenTypeConstants;
    }

    public boolean isShowClassNames() {
        return this.showClassNames;
    }

    public void setShowClassNames(boolean showClassNames) {
        this.showClassNames = showClassNames;
    }

    private void showAst(AST ast, PrintStream out) {
        this.showAst(ast, new PrintWriter(out));
    }

    public void showAst(AST ast, PrintWriter pw) {
        ArrayList parents = new ArrayList();
        this.showAst(parents, pw, ast);
        pw.flush();
    }

    public String showAsString(AST ast, String header) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.println(header);
        this.showAst(ast, ps);
        ps.flush();
        return new String(baos.toByteArray());
    }

    public static String getConstantName(Class tokenTypeConstants, int type) {
        String tokenTypeName = null;
        if (tokenTypeConstants != null) {
            Field field;
            Field[] fields = tokenTypeConstants.getFields();
            for (int i2 = 0; i2 < fields.length && (tokenTypeName = ASTPrinter.getTokenTypeName(field = fields[i2], type, true)) == null; ++i2) {
            }
        }
        if (tokenTypeName == null) {
            tokenTypeName = Integer.toString(type);
        }
        return tokenTypeName;
    }

    private static String getTokenTypeName(Field field, int type, boolean checkType) {
        if (Modifier.isStatic(field.getModifiers())) {
            try {
                Integer integer;
                Object value = field.get(null);
                if (!checkType) {
                    return field.getName();
                }
                if (value instanceof Integer && (integer = (Integer)value) == type) {
                    return field.getName();
                }
            }
            catch (IllegalArgumentException ignore) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getTokenTypeName(int type) {
        if (this.tokenTypeConstants == null) {
            return Integer.toString(type);
        }
        if (this.tokenTypeNamesByTokenType == null) {
            Field[] fields = this.tokenTypeConstants.getFields();
            this.tokenTypeNamesByTokenType = new HashMap();
            String tokenTypeName = null;
            for (int i2 = 0; i2 < fields.length; ++i2) {
                Field field = fields[i2];
                tokenTypeName = ASTPrinter.getTokenTypeName(field, type, false);
                if (tokenTypeName == null) continue;
                try {
                    this.tokenTypeNamesByTokenType.put(field.get(null), field.getName());
                    continue;
                }
                catch (IllegalAccessException ignore) {
                    // empty catch block
                }
            }
        }
        return (String)this.tokenTypeNamesByTokenType.get(new Integer(type));
    }

    private void showAst(ArrayList parents, PrintWriter pw, AST ast) {
        if (ast == null) {
            pw.println("AST is null!");
            return;
        }
        for (int i2 = 0; i2 < parents.size(); ++i2) {
            AST parent = (AST)parents.get(i2);
            if (parent.getNextSibling() == null) {
                pw.print("   ");
                continue;
            }
            pw.print(" | ");
        }
        if (ast.getNextSibling() == null) {
            pw.print(" \\-");
        } else {
            pw.print(" +-");
        }
        this.showNode(pw, ast);
        ArrayList<AST> newParents = new ArrayList<AST>(parents);
        newParents.add(ast);
        for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.showAst(newParents, pw, child);
        }
        newParents.clear();
    }

    private void showNode(PrintWriter pw, AST ast) {
        String s = this.nodeToString(ast, this.isShowClassNames());
        pw.println(s);
    }

    public String nodeToString(AST ast, boolean showClassName) {
        if (ast == null) {
            return "{null}";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(this.getTokenTypeName(ast.getType())).append("] ");
        if (showClassName) {
            buf.append(StringHelper.unqualify(ast.getClass().getName())).append(": ");
        }
        buf.append("'");
        String text = ast.getText();
        ASTPrinter.appendEscapedMultibyteChars(text, buf);
        buf.append("'");
        if (ast instanceof DisplayableNode) {
            DisplayableNode displayableNode = (DisplayableNode)((Object)ast);
            buf.append(" ").append(displayableNode.getDisplayText());
        }
        String s = buf.toString();
        return s;
    }

    public static void appendEscapedMultibyteChars(String text, StringBuffer buf) {
        char[] chars = text.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char aChar = chars[i2];
            if (aChar > '\u0100') {
                buf.append("\\u");
                buf.append(Integer.toHexString(aChar));
                continue;
            }
            buf.append(aChar);
        }
    }

    public static String escapeMultibyteChars(String text) {
        StringBuffer buf = new StringBuffer();
        ASTPrinter.appendEscapedMultibyteChars(text, buf);
        return buf.toString();
    }
}

