/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.ASTFactory;
import antlr.collections.AST;
import antlr.collections.impl.ASTArray;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.hql.ast.util.NodeTraverser;

public final class ASTUtil {
    private ASTUtil() {
    }

    public static AST create(ASTFactory astFactory, int type, String text) {
        AST node = astFactory.create(type, text);
        return node;
    }

    public static AST createSibling(ASTFactory astFactory, int type, String text, AST prevSibling) {
        AST node = astFactory.create(type, text);
        node.setNextSibling(prevSibling.getNextSibling());
        prevSibling.setNextSibling(node);
        return node;
    }

    public static AST insertSibling(AST node, AST prevSibling) {
        node.setNextSibling(prevSibling.getNextSibling());
        prevSibling.setNextSibling(node);
        return node;
    }

    public static AST createBinarySubtree(ASTFactory factory, int parentType, String parentText, AST child1, AST child2) {
        ASTArray array = ASTUtil.createAstArray(factory, 3, parentType, parentText, child1);
        array.add(child2);
        return factory.make(array);
    }

    public static AST createParent(ASTFactory factory, int parentType, String parentText, AST child) {
        ASTArray array = ASTUtil.createAstArray(factory, 2, parentType, parentText, child);
        return factory.make(array);
    }

    public static AST createTree(ASTFactory factory, AST[] nestedChildren) {
        int limit;
        AST[] array = new AST[2];
        for (int i2 = limit = nestedChildren.length - 1; i2 >= 0; --i2) {
            if (i2 == limit) continue;
            array[1] = nestedChildren[i2 + 1];
            array[0] = nestedChildren[i2];
            factory.make(array);
        }
        return array[0];
    }

    public static AST findTypeInChildren(AST parent, int type) {
        AST n2;
        for (n2 = parent.getFirstChild(); n2 != null && n2.getType() != type; n2 = n2.getNextSibling()) {
        }
        return n2;
    }

    public static AST getLastChild(AST n2) {
        return ASTUtil.getLastSibling(n2.getFirstChild());
    }

    private static AST getLastSibling(AST a2) {
        AST last = null;
        while (a2 != null) {
            last = a2;
            a2 = a2.getNextSibling();
        }
        return last;
    }

    public static String getDebugString(AST n2) {
        StringBuffer buf = new StringBuffer();
        buf.append("[ ");
        buf.append(n2 == null ? "{null}" : n2.toStringTree());
        buf.append(" ]");
        return buf.toString();
    }

    public static AST findPreviousSibling(AST parent, AST child) {
        AST prev = null;
        for (AST n2 = parent.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2 == child) {
                return prev;
            }
            prev = n2;
        }
        throw new IllegalArgumentException("Child not found in parent!");
    }

    public static boolean isDirectChild(AST fixture, AST test) {
        for (AST n2 = fixture.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2 != test) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubtreeChild(AST fixture, AST test) {
        for (AST n2 = fixture.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2 == test) {
                return true;
            }
            if (n2.getFirstChild() == null || !ASTUtil.isSubtreeChild(n2, test)) continue;
            return true;
        }
        return false;
    }

    public static void makeSiblingOfParent(AST parent, AST child) {
        AST prev = ASTUtil.findPreviousSibling(parent, child);
        if (prev != null) {
            prev.setNextSibling(child.getNextSibling());
        } else {
            parent.setFirstChild(child.getNextSibling());
        }
        child.setNextSibling(parent.getNextSibling());
        parent.setNextSibling(child);
    }

    public static String getPathText(AST n2) {
        StringBuffer buf = new StringBuffer();
        ASTUtil.getPathText(buf, n2);
        return buf.toString();
    }

    private static void getPathText(StringBuffer buf, AST n2) {
        AST firstChild = n2.getFirstChild();
        if (firstChild != null) {
            ASTUtil.getPathText(buf, firstChild);
        }
        buf.append(n2.getText());
        if (firstChild != null && firstChild.getNextSibling() != null) {
            ASTUtil.getPathText(buf, firstChild.getNextSibling());
        }
    }

    public static boolean hasExactlyOneChild(AST n2) {
        return n2 != null && n2.getFirstChild() != null && n2.getFirstChild().getNextSibling() == null;
    }

    public static void appendSibling(AST n2, AST s) {
        while (n2.getNextSibling() != null) {
            n2 = n2.getNextSibling();
        }
        n2.setNextSibling(s);
    }

    public static void insertChild(AST parent, AST child) {
        if (parent.getFirstChild() == null) {
            parent.setFirstChild(child);
        } else {
            AST n2 = parent.getFirstChild();
            parent.setFirstChild(child);
            child.setNextSibling(n2);
        }
    }

    private static ASTArray createAstArray(ASTFactory factory, int size, int parentType, String parentText, AST child1) {
        ASTArray array = new ASTArray(size);
        array.add(factory.create(parentType, parentText));
        array.add(child1);
        return array;
    }

    public static List collectChildren(AST root, FilterPredicate predicate) {
        return new CollectingNodeVisitor(predicate).collect(root);
    }

    private static void collectChildren(List children, AST root, FilterPredicate predicate) {
        for (AST n2 = root.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (predicate == null || !predicate.exclude(n2)) {
                children.add(n2);
            }
            ASTUtil.collectChildren(children, n2, predicate);
        }
    }

    private static class CollectingNodeVisitor
    implements NodeTraverser.VisitationStrategy {
        private final FilterPredicate predicate;
        private final List collectedNodes = new ArrayList();

        public CollectingNodeVisitor(FilterPredicate predicate) {
            this.predicate = predicate;
        }

        public void visit(AST node) {
            if (this.predicate == null || !this.predicate.exclude(node)) {
                this.collectedNodes.add(node);
            }
        }

        public List getCollectedNodes() {
            return this.collectedNodes;
        }

        public List collect(AST root) {
            NodeTraverser traverser = new NodeTraverser(this);
            traverser.traverseDepthFirst(root);
            return this.collectedNodes;
        }
    }

    public static abstract class IncludePredicate
    implements FilterPredicate {
        public final boolean exclude(AST node) {
            return !this.include(node);
        }

        public abstract boolean include(AST var1);
    }

    public static interface FilterPredicate {
        public boolean exclude(AST var1);
    }
}

