/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.jdbc.AbstractBatcher;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.jdbc.Expectation;

public class BatchingBatcher
extends AbstractBatcher {
    private int batchSize;
    private Expectation[] expectations = new Expectation[this.getFactory().getSettings().getJdbcBatchSize()];

    public BatchingBatcher(ConnectionManager connectionManager, Interceptor interceptor) {
        super(connectionManager, interceptor);
    }

    public void addToBatch(Expectation expectation) throws SQLException, HibernateException {
        if (!expectation.canBeBatched()) {
            throw new HibernateException("attempting to batch an operation which cannot be batched");
        }
        PreparedStatement batchUpdate = this.getStatement();
        batchUpdate.addBatch();
        this.expectations[this.batchSize++] = expectation;
        if (this.batchSize == this.getFactory().getSettings().getJdbcBatchSize()) {
            this.doExecuteBatch(batchUpdate);
        }
    }

    protected void doExecuteBatch(PreparedStatement ps) throws SQLException, HibernateException {
        if (this.batchSize == 0) {
            log.debug("no batched statements to execute");
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Executing batch size: " + this.batchSize);
            }
            try {
                this.checkRowCounts(ps.executeBatch(), ps);
            }
            catch (RuntimeException re) {
                log.error("Exception executing batch: ", re);
                throw re;
            }
            finally {
                this.batchSize = 0;
            }
        }
    }

    private void checkRowCounts(int[] rowCounts, PreparedStatement ps) throws SQLException, HibernateException {
        int numberOfRowCounts = rowCounts.length;
        if (numberOfRowCounts != this.batchSize) {
            log.warn("JDBC driver did not return the expected number of row counts");
        }
        for (int i2 = 0; i2 < numberOfRowCounts; ++i2) {
            this.expectations[i2].verifyOutcome(rowCounts[i2], ps, i2);
        }
    }
}

