/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.DefaultEntityAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedCollectionAliases;
import org.hibernate.loader.Loader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.BagType;

public abstract class BasicLoader
extends Loader {
    protected static final String[] NO_SUFFIX = new String[]{""};
    private EntityAliases[] descriptors;
    private CollectionAliases[] collectionDescriptors;

    public BasicLoader(SessionFactoryImplementor factory) {
        super(factory);
    }

    protected final EntityAliases[] getEntityAliases() {
        return this.descriptors;
    }

    protected final CollectionAliases[] getCollectionAliases() {
        return this.collectionDescriptors;
    }

    protected abstract String[] getSuffixes();

    protected abstract String[] getCollectionSuffixes();

    protected void postInstantiate() {
        Loadable[] persisters = this.getEntityPersisters();
        String[] suffixes = this.getSuffixes();
        this.descriptors = new EntityAliases[persisters.length];
        for (int i2 = 0; i2 < this.descriptors.length; ++i2) {
            this.descriptors[i2] = new DefaultEntityAliases(persisters[i2], suffixes[i2]);
        }
        CollectionPersister[] collectionPersisters = this.getCollectionPersisters();
        int bagCount = 0;
        if (collectionPersisters != null) {
            String[] collectionSuffixes = this.getCollectionSuffixes();
            this.collectionDescriptors = new CollectionAliases[collectionPersisters.length];
            for (int i3 = 0; i3 < collectionPersisters.length; ++i3) {
                if (this.isBag(collectionPersisters[i3])) {
                    ++bagCount;
                }
                this.collectionDescriptors[i3] = new GeneratedCollectionAliases(collectionPersisters[i3], collectionSuffixes[i3]);
            }
        } else {
            this.collectionDescriptors = null;
        }
        if (bagCount > 1) {
            throw new HibernateException("cannot simultaneously fetch multiple bags");
        }
    }

    private boolean isBag(CollectionPersister collectionPersister) {
        return collectionPersister.getCollectionType().getClass().isAssignableFrom(BagType.class);
    }

    public static String[] generateSuffixes(int length) {
        return BasicLoader.generateSuffixes(0, length);
    }

    public static String[] generateSuffixes(int seed, int length) {
        if (length == 0) {
            return NO_SUFFIX;
        }
        String[] suffixes = new String[length];
        for (int i2 = 0; i2 < length; ++i2) {
            suffixes[i2] = Integer.toString(i2 + seed) + "_";
        }
        return suffixes;
    }
}

