/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InFragment;
import org.hibernate.sql.Insert;
import org.hibernate.sql.SelectFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.MarkerObject;

public class SingleTableEntityPersister
extends AbstractEntityPersister {
    private final int joinSpan;
    private final String[] qualifiedTableNames;
    private final boolean[] isInverseTable;
    private final boolean[] isNullableTable;
    private final String[][] keyColumnNames;
    private final boolean[] cascadeDeleteEnabled;
    private final boolean hasSequentialSelects;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final boolean[] subclassTableIsLazyClosure;
    private final boolean[] isInverseSubclassTable;
    private final boolean[] isNullableSubclassTable;
    private final boolean[] subclassTableSequentialSelect;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final int[] subclassFormulaTableNumberClosure;
    private final Map subclassesByDiscriminatorValue = new HashMap();
    private final boolean forceDiscriminator;
    private final String discriminatorColumnName;
    private final String discriminatorFormula;
    private final String discriminatorFormulaTemplate;
    private final String discriminatorAlias;
    private final Type discriminatorType;
    private final String discriminatorSQLValue;
    private final boolean discriminatorInsertable;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final Map propertyTableNumbersByNameAndSubclass = new HashMap();
    private final Map sequentialSelectStringsByEntityName = new HashMap();
    private static final Object NULL_DISCRIMINATOR = new MarkerObject("<null discriminator>");
    private static final Object NOT_NULL_DISCRIMINATOR = new MarkerObject("<not null discriminator>");

    /*
     * WARNING - void declaration
     */
    public SingleTableEntityPersister(PersistentClass persistentClass, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory, Mapping mapping) throws HibernateException {
        super(persistentClass, cache, factory);
        Object discriminatorValue;
        Iterator iter;
        this.joinSpan = persistentClass.getJoinClosureSpan() + 1;
        this.qualifiedTableNames = new String[this.joinSpan];
        this.isInverseTable = new boolean[this.joinSpan];
        this.isNullableTable = new boolean[this.joinSpan];
        this.keyColumnNames = new String[this.joinSpan][];
        Table table = persistentClass.getRootTable();
        this.qualifiedTableNames[0] = table.getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
        this.isInverseTable[0] = false;
        this.isNullableTable[0] = false;
        this.keyColumnNames[0] = this.getIdentifierColumnNames();
        this.cascadeDeleteEnabled = new boolean[this.joinSpan];
        this.customSQLInsert = new String[this.joinSpan];
        this.customSQLUpdate = new String[this.joinSpan];
        this.customSQLDelete = new String[this.joinSpan];
        this.insertCallable = new boolean[this.joinSpan];
        this.updateCallable = new boolean[this.joinSpan];
        this.deleteCallable = new boolean[this.joinSpan];
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.joinSpan];
        this.customSQLInsert[0] = persistentClass.getCustomSQLInsert();
        this.insertCallable[0] = this.customSQLInsert[0] != null && persistentClass.isCustomInsertCallable();
        this.insertResultCheckStyles[0] = persistentClass.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[0], this.insertCallable[0]) : persistentClass.getCustomSQLInsertCheckStyle();
        this.customSQLUpdate[0] = persistentClass.getCustomSQLUpdate();
        this.updateCallable[0] = this.customSQLUpdate[0] != null && persistentClass.isCustomUpdateCallable();
        this.updateResultCheckStyles[0] = persistentClass.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[0], this.updateCallable[0]) : persistentClass.getCustomSQLUpdateCheckStyle();
        this.customSQLDelete[0] = persistentClass.getCustomSQLDelete();
        this.deleteCallable[0] = this.customSQLDelete[0] != null && persistentClass.isCustomDeleteCallable();
        this.deleteResultCheckStyles[0] = persistentClass.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[0], this.deleteCallable[0]) : persistentClass.getCustomSQLDeleteCheckStyle();
        Iterator joinIter = persistentClass.getJoinClosureIterator();
        int j2 = 1;
        while (joinIter.hasNext()) {
            Join join = (Join)joinIter.next();
            this.qualifiedTableNames[j2] = join.getTable().getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            this.isInverseTable[j2] = join.isInverse();
            this.isNullableTable[j2] = join.isOptional();
            this.cascadeDeleteEnabled[j2] = join.getKey().isCascadeDeleteEnabled() && factory.getDialect().supportsCascadeDelete();
            this.customSQLInsert[j2] = join.getCustomSQLInsert();
            this.insertCallable[j2] = this.customSQLInsert[j2] != null && join.isCustomInsertCallable();
            this.insertResultCheckStyles[j2] = join.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[j2], this.insertCallable[j2]) : join.getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[j2] = join.getCustomSQLUpdate();
            this.updateCallable[j2] = this.customSQLUpdate[j2] != null && join.isCustomUpdateCallable();
            this.updateResultCheckStyles[j2] = join.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[j2], this.updateCallable[j2]) : join.getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[j2] = join.getCustomSQLDelete();
            this.deleteCallable[j2] = this.customSQLDelete[j2] != null && join.isCustomDeleteCallable();
            this.deleteResultCheckStyles[j2] = join.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[j2], this.deleteCallable[j2]) : join.getCustomSQLDeleteCheckStyle();
            Iterator iter2 = join.getKey().getColumnIterator();
            this.keyColumnNames[j2] = new String[join.getKey().getColumnSpan()];
            int i2 = 0;
            while (iter2.hasNext()) {
                Column col = (Column)iter2.next();
                this.keyColumnNames[j2][i2++] = col.getQuotedName(factory.getDialect());
            }
            ++j2;
        }
        this.constraintOrderedTableNames = new String[this.qualifiedTableNames.length];
        this.constraintOrderedKeyColumnNames = new String[this.qualifiedTableNames.length][];
        int i3 = this.qualifiedTableNames.length - 1;
        int position = 0;
        while (i3 >= 0) {
            this.constraintOrderedTableNames[position] = this.qualifiedTableNames[i3];
            this.constraintOrderedKeyColumnNames[position] = this.keyColumnNames[i3];
            --i3;
            ++position;
        }
        this.spaces = ArrayHelper.join(this.qualifiedTableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        boolean lazyAvailable = this.isInstrumented(EntityMode.POJO);
        boolean hasDeferred = false;
        ArrayList<String> subclassTables = new ArrayList<String>();
        ArrayList<String[]> joinKeyColumns = new ArrayList<String[]>();
        ArrayList<Boolean> isConcretes = new ArrayList<Boolean>();
        ArrayList<Boolean> isDeferreds = new ArrayList<Boolean>();
        ArrayList<Boolean> isInverses = new ArrayList<Boolean>();
        ArrayList<Boolean> isNullables = new ArrayList<Boolean>();
        ArrayList<Boolean> isLazies = new ArrayList<Boolean>();
        subclassTables.add(this.qualifiedTableNames[0]);
        joinKeyColumns.add(this.getIdentifierColumnNames());
        isConcretes.add(Boolean.TRUE);
        isDeferreds.add(Boolean.FALSE);
        isInverses.add(Boolean.FALSE);
        isNullables.add(Boolean.FALSE);
        isLazies.add(Boolean.FALSE);
        joinIter = persistentClass.getSubclassJoinClosureIterator();
        while (joinIter.hasNext()) {
            Join join = (Join)joinIter.next();
            isConcretes.add(new Boolean(persistentClass.isClassOrSuperclassJoin(join)));
            isDeferreds.add(new Boolean(join.isSequentialSelect()));
            isInverses.add(new Boolean(join.isInverse()));
            isNullables.add(new Boolean(join.isOptional()));
            isLazies.add(new Boolean(lazyAvailable && join.isLazy()));
            if (join.isSequentialSelect() && !persistentClass.isClassOrSuperclassJoin(join)) {
                hasDeferred = true;
            }
            subclassTables.add(join.getTable().getQualifiedName(factory.getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName()));
            iter = join.getKey().getColumnIterator();
            String[] keyCols = new String[join.getKey().getColumnSpan()];
            int i4 = 0;
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                keyCols[i4++] = col.getQuotedName(factory.getDialect());
            }
            joinKeyColumns.add(keyCols);
        }
        this.subclassTableSequentialSelect = ArrayHelper.toBooleanArray(isDeferreds);
        this.subclassTableNameClosure = ArrayHelper.toStringArray(subclassTables);
        this.subclassTableIsLazyClosure = ArrayHelper.toBooleanArray(isLazies);
        this.subclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(joinKeyColumns);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(isConcretes);
        this.isInverseSubclassTable = ArrayHelper.toBooleanArray(isInverses);
        this.isNullableSubclassTable = ArrayHelper.toBooleanArray(isNullables);
        this.hasSequentialSelects = hasDeferred;
        if (persistentClass.isPolymorphic()) {
            Value discrimValue = persistentClass.getDiscriminator();
            if (discrimValue == null) {
                throw new MappingException("discriminator mapping required for single table polymorphic persistence");
            }
            this.forceDiscriminator = persistentClass.isForceDiscriminator();
            Selectable selectable = (Selectable)discrimValue.getColumnIterator().next();
            if (discrimValue.hasFormula()) {
                Formula formula = (Formula)selectable;
                this.discriminatorFormula = formula.getFormula();
                this.discriminatorFormulaTemplate = formula.getTemplate(factory.getDialect(), factory.getSqlFunctionRegistry());
                this.discriminatorColumnName = null;
                this.discriminatorAlias = "clazz_";
            } else {
                Column column = (Column)selectable;
                this.discriminatorColumnName = column.getQuotedName(factory.getDialect());
                this.discriminatorAlias = column.getAlias(factory.getDialect(), persistentClass.getRootTable());
                this.discriminatorFormula = null;
                this.discriminatorFormulaTemplate = null;
            }
            this.discriminatorType = persistentClass.getDiscriminator().getType();
            if (persistentClass.isDiscriminatorValueNull()) {
                discriminatorValue = NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = "null";
                this.discriminatorInsertable = false;
            } else if (persistentClass.isDiscriminatorValueNotNull()) {
                discriminatorValue = NOT_NULL_DISCRIMINATOR;
                this.discriminatorSQLValue = "not null";
                this.discriminatorInsertable = false;
            } else {
                this.discriminatorInsertable = persistentClass.isDiscriminatorInsertable() && !discrimValue.hasFormula();
                try {
                    DiscriminatorType dtype = (DiscriminatorType)this.discriminatorType;
                    discriminatorValue = dtype.stringToObject(persistentClass.getDiscriminatorValue());
                    this.discriminatorSQLValue = dtype.objectToSQLString(discriminatorValue, factory.getDialect());
                }
                catch (ClassCastException cce) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception e2) {
                    throw new MappingException("Could not format discriminator value to SQL string", e2);
                }
            }
        } else {
            this.forceDiscriminator = false;
            this.discriminatorInsertable = false;
            this.discriminatorColumnName = null;
            this.discriminatorAlias = null;
            this.discriminatorType = null;
            discriminatorValue = null;
            this.discriminatorSQLValue = null;
            this.discriminatorFormula = null;
            this.discriminatorFormulaTemplate = null;
        }
        this.propertyTableNumbers = new int[this.getPropertySpan()];
        iter = persistentClass.getPropertyClosureIterator();
        int i5 = 0;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            this.propertyTableNumbers[i5++] = persistentClass.getJoinNumber(prop);
        }
        ArrayList<Integer> columnJoinNumbers = new ArrayList<Integer>();
        ArrayList<Integer> formulaJoinedNumbers = new ArrayList<Integer>();
        ArrayList<Integer> propertyJoinNumbers = new ArrayList<Integer>();
        iter = persistentClass.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            Integer join = new Integer(persistentClass.getJoinNumber(prop));
            propertyJoinNumbers.add(join);
            this.propertyTableNumbersByNameAndSubclass.put(prop.getPersistentClass().getEntityName() + '.' + prop.getName(), join);
            Iterator citer = prop.getColumnIterator();
            while (citer.hasNext()) {
                Selectable thing = (Selectable)citer.next();
                if (thing.isFormula()) {
                    formulaJoinedNumbers.add(join);
                    continue;
                }
                columnJoinNumbers.add(join);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray(columnJoinNumbers);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray(formulaJoinedNumbers);
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(propertyJoinNumbers);
        int subclassSpan = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[subclassSpan];
        this.subclassClosure[0] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            void var17_20;
            this.subclassesByDiscriminatorValue.put(var17_20, this.getEntityName());
        }
        if (persistentClass.isPolymorphic()) {
            iter = persistentClass.getSubclassIterator();
            int k2 = 1;
            while (iter.hasNext()) {
                Subclass sc = (Subclass)iter.next();
                this.subclassClosure[k2++] = sc.getEntityName();
                if (sc.isDiscriminatorValueNull()) {
                    this.subclassesByDiscriminatorValue.put(NULL_DISCRIMINATOR, sc.getEntityName());
                    continue;
                }
                if (sc.isDiscriminatorValueNotNull()) {
                    this.subclassesByDiscriminatorValue.put(NOT_NULL_DISCRIMINATOR, sc.getEntityName());
                    continue;
                }
                try {
                    DiscriminatorType dtype = (DiscriminatorType)this.discriminatorType;
                    this.subclassesByDiscriminatorValue.put(dtype.stringToObject(sc.getDiscriminatorValue()), sc.getEntityName());
                }
                catch (ClassCastException cce) {
                    throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                }
                catch (Exception e3) {
                    throw new MappingException("Error parsing discriminator value", e3);
                }
            }
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(mapping);
    }

    protected boolean isInverseTable(int j2) {
        return this.isInverseTable[j2];
    }

    protected boolean isInverseSubclassTable(int j2) {
        return this.isInverseSubclassTable[j2];
    }

    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    protected String getDiscriminatorAlias() {
        return this.discriminatorAlias;
    }

    protected String getDiscriminatorFormulaTemplate() {
        return this.discriminatorFormulaTemplate;
    }

    public String getTableName() {
        return this.qualifiedTableNames[0];
    }

    public Type getDiscriminatorType() {
        return this.discriminatorType;
    }

    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLValue;
    }

    public String[] getSubclassClosure() {
        return this.subclassClosure;
    }

    public String getSubclassForDiscriminatorValue(Object value) {
        if (value == null) {
            return (String)this.subclassesByDiscriminatorValue.get(NULL_DISCRIMINATOR);
        }
        String result = (String)this.subclassesByDiscriminatorValue.get(value);
        if (result == null) {
            result = (String)this.subclassesByDiscriminatorValue.get(NOT_NULL_DISCRIMINATOR);
        }
        return result;
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    protected boolean isDiscriminatorFormula() {
        return this.discriminatorColumnName == null;
    }

    protected String getDiscriminatorFormula() {
        return this.discriminatorFormula;
    }

    protected String getTableName(int j2) {
        return this.qualifiedTableNames[j2];
    }

    protected String[] getKeyColumns(int j2) {
        return this.keyColumnNames[j2];
    }

    protected boolean isTableCascadeDeleteEnabled(int j2) {
        return this.cascadeDeleteEnabled[j2];
    }

    protected boolean isPropertyOfTable(int property, int j2) {
        return this.propertyTableNumbers[property] == j2;
    }

    protected boolean isSubclassTableSequentialSelect(int j2) {
        return this.subclassTableSequentialSelect[j2] && !this.isClassOrSuperclassTable[j2];
    }

    public String fromTableFragment(String name) {
        return this.getTableName() + ' ' + name;
    }

    public String filterFragment(String alias) throws MappingException {
        String result = this.discriminatorFilterFragment(alias);
        if (this.hasWhere()) {
            result = result + " and " + this.getSQLWhereString(alias);
        }
        return result;
    }

    public String oneToManyFilterFragment(String alias) throws MappingException {
        return this.forceDiscriminator ? this.discriminatorFilterFragment(alias) : "";
    }

    private String discriminatorFilterFragment(String alias) throws MappingException {
        if (this.needsDiscriminator()) {
            InFragment frag = new InFragment();
            if (this.isDiscriminatorFormula()) {
                frag.setFormula(alias, this.getDiscriminatorFormulaTemplate());
            } else {
                frag.setColumn(alias, this.getDiscriminatorColumnName());
            }
            String[] subclasses = this.getSubclassClosure();
            for (int i2 = 0; i2 < subclasses.length; ++i2) {
                Queryable queryable = (Queryable)this.getFactory().getEntityPersister(subclasses[i2]);
                if (queryable.isAbstract()) continue;
                frag.addValue(queryable.getDiscriminatorSQLValue());
            }
            StringBuffer buf = new StringBuffer(50).append(" and ").append(frag.toFragmentString());
            return buf.toString();
        }
        return "";
    }

    private boolean needsDiscriminator() {
        return this.forceDiscriminator || this.isInherited();
    }

    public String getSubclassPropertyTableName(int i2) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[i2]];
    }

    protected void addDiscriminatorToSelect(SelectFragment select, String name, String suffix) {
        if (this.isDiscriminatorFormula()) {
            select.addFormula(name, this.getDiscriminatorFormulaTemplate(), this.getDiscriminatorAlias());
        } else {
            select.addColumn(name, this.getDiscriminatorColumnName(), this.getDiscriminatorAlias());
        }
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return this.propertyTableNumbers;
    }

    protected int getSubclassPropertyTableNumber(int i2) {
        return this.subclassPropertyTableNumberClosure[i2];
    }

    public int getTableSpan() {
        return this.joinSpan;
    }

    protected void addDiscriminatorToInsert(Insert insert) {
        if (this.discriminatorInsertable) {
            insert.addColumn(this.getDiscriminatorColumnName(), this.discriminatorSQLValue);
        }
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return this.subclassColumnTableNumberClosure;
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return this.subclassFormulaTableNumberClosure;
    }

    protected int[] getPropertyTableNumbers() {
        return this.propertyTableNumbers;
    }

    protected boolean isSubclassPropertyDeferred(String propertyName, String entityName) {
        return this.hasSequentialSelects && this.isSubclassTableSequentialSelect(this.getSubclassPropertyTableNumber(propertyName, entityName));
    }

    public boolean hasSequentialSelect() {
        return this.hasSequentialSelects;
    }

    private int getSubclassPropertyTableNumber(String propertyName, String entityName) {
        Type type = this.propertyMapping.toType(propertyName);
        if (type.isAssociationType() && ((AssociationType)type).useLHSPrimaryKey()) {
            return 0;
        }
        Integer tabnum = (Integer)this.propertyTableNumbersByNameAndSubclass.get(entityName + '.' + propertyName);
        return tabnum == null ? 0 : tabnum;
    }

    protected String getSequentialSelect(String entityName) {
        return (String)this.sequentialSelectStringsByEntityName.get(entityName);
    }

    private String generateSequentialSelect(Loadable persister) {
        AbstractEntityPersister subclassPersister = (AbstractEntityPersister)persister;
        HashSet<Integer> tableNumbers = new HashSet<Integer>();
        String[] props = subclassPersister.getPropertyNames();
        String[] classes = subclassPersister.getPropertySubclassNames();
        for (int i2 = 0; i2 < props.length; ++i2) {
            int propTableNumber = this.getSubclassPropertyTableNumber(props[i2], classes[i2]);
            if (!this.isSubclassTableSequentialSelect(propTableNumber) || this.isSubclassTableLazy(propTableNumber)) continue;
            tableNumbers.add(new Integer(propTableNumber));
        }
        if (tableNumbers.isEmpty()) {
            return null;
        }
        ArrayList<Integer> columnNumbers = new ArrayList<Integer>();
        int[] columnTableNumbers = this.getSubclassColumnTableNumberClosure();
        for (int i3 = 0; i3 < this.getSubclassColumnClosure().length; ++i3) {
            if (!tableNumbers.contains(new Integer(columnTableNumbers[i3]))) continue;
            columnNumbers.add(new Integer(i3));
        }
        ArrayList<Integer> formulaNumbers = new ArrayList<Integer>();
        int[] formulaTableNumbers = this.getSubclassColumnTableNumberClosure();
        for (int i4 = 0; i4 < this.getSubclassFormulaTemplateClosure().length; ++i4) {
            if (!tableNumbers.contains(new Integer(formulaTableNumbers[i4]))) continue;
            formulaNumbers.add(new Integer(i4));
        }
        return this.renderSelect(ArrayHelper.toIntArray(tableNumbers), ArrayHelper.toIntArray(columnNumbers), ArrayHelper.toIntArray(formulaNumbers));
    }

    protected String[] getSubclassTableKeyColumns(int j2) {
        return this.subclassTableKeyColumnClosure[j2];
    }

    public String getSubclassTableName(int j2) {
        return this.subclassTableNameClosure[j2];
    }

    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    protected boolean isClassOrSuperclassTable(int j2) {
        return this.isClassOrSuperclassTable[j2];
    }

    protected boolean isSubclassTableLazy(int j2) {
        return this.subclassTableIsLazyClosure[j2];
    }

    protected boolean isNullableTable(int j2) {
        return this.isNullableTable[j2];
    }

    protected boolean isNullableSubclassTable(int j2) {
        return this.isNullableSubclassTable[j2];
    }

    public String getPropertyTableName(String propertyName) {
        Integer index = this.getEntityMetamodel().getPropertyIndexOrNull(propertyName);
        if (index == null) {
            return null;
        }
        return this.qualifiedTableNames[this.propertyTableNumbers[index]];
    }

    public void postInstantiate() {
        super.postInstantiate();
        if (this.hasSequentialSelects) {
            String[] entityNames = this.getSubclassClosure();
            for (int i2 = 1; i2 < entityNames.length; ++i2) {
                Loadable loadable = (Loadable)this.getFactory().getEntityPersister(entityNames[i2]);
                if (loadable.isAbstract()) continue;
                String sequentialSelect = this.generateSequentialSelect(loadable);
                this.sequentialSelectStringsByEntityName.put(entityNames[i2], sequentialSelect);
            }
        }
    }

    public boolean isMultiTable() {
        return this.getTableSpan() > 1;
    }

    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }
}

