/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import org.hibernate.PropertyNotFoundException;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class ChainedPropertyAccessor
implements PropertyAccessor {
    final PropertyAccessor[] chain;

    public ChainedPropertyAccessor(PropertyAccessor[] chain) {
        this.chain = chain;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        Getter result = null;
        for (int i2 = 0; i2 < this.chain.length; ++i2) {
            PropertyAccessor candidate = this.chain[i2];
            try {
                result = candidate.getGetter(theClass, propertyName);
                return result;
            }
            catch (PropertyNotFoundException pnfe) {
                continue;
            }
        }
        throw new PropertyNotFoundException("Could not find getter for " + propertyName + " on " + theClass);
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        Setter result = null;
        for (int i2 = 0; i2 < this.chain.length; ++i2) {
            PropertyAccessor candidate = this.chain[i2];
            try {
                result = candidate.getSetter(theClass, propertyName);
                return result;
            }
            catch (PropertyNotFoundException pnfe) {
                continue;
            }
        }
        throw new PropertyNotFoundException("Could not find setter for " + propertyName + " on " + theClass);
    }
}

