/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.StringHelper;

public class ForUpdateFragment {
    private final StringBuffer aliases = new StringBuffer();
    private boolean isNowaitEnabled;
    private final Dialect dialect;

    public ForUpdateFragment(Dialect dialect) {
        this.dialect = dialect;
    }

    public ForUpdateFragment(Dialect dialect, Map lockModes, Map keyColumnNames) throws QueryException {
        this(dialect);
        LockMode upgradeType = null;
        Iterator iter = lockModes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            LockMode lockMode = (LockMode)me.getValue();
            if (!LockMode.READ.lessThan(lockMode)) continue;
            String tableAlias = (String)me.getKey();
            if (dialect.forUpdateOfColumns()) {
                String[] keyColumns = (String[])keyColumnNames.get(tableAlias);
                if (keyColumns == null) {
                    throw new IllegalArgumentException("alias not found: " + tableAlias);
                }
                keyColumns = StringHelper.qualify(tableAlias, keyColumns);
                for (int i2 = 0; i2 < keyColumns.length; ++i2) {
                    this.addTableAlias(keyColumns[i2]);
                }
            } else {
                this.addTableAlias(tableAlias);
            }
            if (upgradeType != null && lockMode != upgradeType) {
                throw new QueryException("mixed LockModes");
            }
            upgradeType = lockMode;
        }
        if (upgradeType == LockMode.UPGRADE_NOWAIT) {
            this.setNowaitEnabled(true);
        }
    }

    public ForUpdateFragment addTableAlias(String alias) {
        if (this.aliases.length() > 0) {
            this.aliases.append(", ");
        }
        this.aliases.append(alias);
        return this;
    }

    public String toFragmentString() {
        if (this.aliases.length() == 0) {
            return "";
        }
        return this.isNowaitEnabled ? this.dialect.getForUpdateNowaitString(this.aliases.toString()) : this.dialect.getForUpdateString(this.aliases.toString());
    }

    public ForUpdateFragment setNowaitEnabled(boolean nowait) {
        this.isNowaitEnabled = nowait;
        return this;
    }
}

