/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaUpdate {
    private static final Log log = LogFactory.getLog(SchemaUpdate.class);
    private ConnectionHelper connectionHelper;
    private Configuration configuration;
    private Dialect dialect;
    private List exceptions;

    public SchemaUpdate(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaUpdate(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionHelper = new ManagedProviderConnectionHelper(props);
        this.exceptions = new ArrayList();
    }

    public SchemaUpdate(Configuration cfg, Settings settings) throws HibernateException {
        this.configuration = cfg;
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.exceptions = new ArrayList();
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean doUpdate = true;
            String propFile = null;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].startsWith("--")) {
                    if (args[i2].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i2].startsWith("--properties=")) {
                        propFile = args[i2].substring(13);
                        continue;
                    }
                    if (args[i2].startsWith("--config=")) {
                        cfg.configure(args[i2].substring(9));
                        continue;
                    }
                    if (args[i2].startsWith("--text")) {
                        doUpdate = false;
                        continue;
                    }
                    if (!args[i2].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i2].substring(9)).newInstance());
                    continue;
                }
                cfg.addFile(args[i2]);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            new SchemaUpdate(cfg).execute(script, doUpdate);
        }
        catch (Exception e2) {
            log.error("Error running schema update", e2);
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(boolean script, boolean doUpdate) {
        block17: {
            DatabaseMetadata meta;
            log.info("Running hbm2ddl schema update");
            Connection connection = null;
            Statement stmt = null;
            this.exceptions.clear();
            try {
                log.info("fetching database metadata");
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                meta = new DatabaseMetadata(connection, this.dialect);
                stmt = connection.createStatement();
            }
            catch (SQLException sqle) {
                this.exceptions.add(sqle);
                log.error("could not get database metadata", sqle);
                throw sqle;
            }
            log.info("updating schema");
            String[] createSQL = this.configuration.generateSchemaUpdateScript(this.dialect, meta);
            for (int j2 = 0; j2 < createSQL.length; ++j2) {
                String sql = createSQL[j2];
                try {
                    if (script) {
                        System.out.println(sql);
                    }
                    if (!doUpdate) continue;
                    log.debug(sql);
                    stmt.executeUpdate(sql);
                    continue;
                }
                catch (SQLException e2) {
                    this.exceptions.add(e2);
                    log.error("Unsuccessful: " + sql);
                    log.error(e2.getMessage());
                }
            }
            log.info("schema update complete");
            Object var11_12 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.connectionHelper.release();
            }
            catch (Exception e3) {
                this.exceptions.add(e3);
                log.error("Error closing connection", e3);
            }
            break block17;
            {
                catch (Exception e4) {
                    this.exceptions.add(e4);
                    log.error("could not complete schema update", e4);
                    Object var11_13 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        this.connectionHelper.release();
                    }
                    catch (Exception e3) {
                        this.exceptions.add(e3);
                        log.error("Error closing connection", e3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.connectionHelper.release();
                }
                catch (Exception e3) {
                    this.exceptions.add(e3);
                    log.error("Error closing connection", e3);
                }
                throw throwable;
            }
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }
}

