/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.instrument.javassist;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javassist.bytecode.ClassFile;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.javassist.BytecodeProviderImpl;
import org.hibernate.bytecode.util.BasicClassFilter;
import org.hibernate.bytecode.util.ClassDescriptor;
import org.hibernate.tool.instrument.BasicInstrumentationTask;

public class InstrumentTask
extends BasicInstrumentationTask {
    private static final BasicClassFilter CLASS_FILTER = new BasicClassFilter();
    private final BytecodeProviderImpl provider = new BytecodeProviderImpl();
    static /* synthetic */ Class class$org$hibernate$bytecode$javassist$FieldHandled;

    protected ClassDescriptor getClassDescriptor(byte[] bytecode) throws IOException {
        return new CustomClassDescriptor(bytecode);
    }

    protected ClassTransformer getClassTransformer(ClassDescriptor descriptor) {
        if (descriptor.isInstrumented()) {
            this.logger.verbose("class [" + descriptor.getName() + "] already instrumented");
            return null;
        }
        return this.provider.getTransformer(CLASS_FILTER, new BasicInstrumentationTask.CustomFieldFilter(descriptor));
    }

    private static class CustomClassDescriptor
    implements ClassDescriptor {
        private final byte[] bytes;
        private final ClassFile classFile;

        public CustomClassDescriptor(byte[] bytes) throws IOException {
            this.bytes = bytes;
            this.classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(bytes)));
        }

        public String getName() {
            return this.classFile.getName();
        }

        public boolean isInstrumented() {
            String[] intfs = this.classFile.getInterfaces();
            for (int i2 = 0; i2 < intfs.length; ++i2) {
                if (!(class$org$hibernate$bytecode$javassist$FieldHandled == null ? InstrumentTask.class$("org.hibernate.bytecode.javassist.FieldHandled") : class$org$hibernate$bytecode$javassist$FieldHandled).getName().equals(intfs[i2])) continue;
                return true;
            }
            return false;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

