/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.property.ChainedPropertyAccessor;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.transform.ResultTransformer;

public class AliasToBeanResultTransformer
implements ResultTransformer {
    private final Class resultClass;
    private Setter[] setters;
    private PropertyAccessor propertyAccessor;

    public AliasToBeanResultTransformer(Class resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass cannot be null");
        }
        this.resultClass = resultClass;
        this.propertyAccessor = new ChainedPropertyAccessor(new PropertyAccessor[]{PropertyAccessorFactory.getPropertyAccessor(resultClass, null), PropertyAccessorFactory.getPropertyAccessor("field")});
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        Object result;
        try {
            int i2;
            if (this.setters == null) {
                this.setters = new Setter[aliases.length];
                for (i2 = 0; i2 < aliases.length; ++i2) {
                    String alias = aliases[i2];
                    if (alias == null) continue;
                    this.setters[i2] = this.propertyAccessor.getSetter(this.resultClass, alias);
                }
            }
            result = this.resultClass.newInstance();
            for (i2 = 0; i2 < aliases.length; ++i2) {
                if (this.setters[i2] == null) continue;
                this.setters[i2].set(result, tuple[i2], null);
            }
        }
        catch (InstantiationException e2) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        catch (IllegalAccessException e3) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        return result;
    }

    public List transformList(List collection) {
        return collection;
    }
}

