/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.tuple.EntityModeToTuplizerMapping;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.component.ComponentMetamodel;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.AbstractType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;

public class ComponentType
extends AbstractType
implements AbstractComponentType {
    private final String[] propertyNames;
    private final Type[] propertyTypes;
    private final boolean[] propertyNullability;
    protected final int propertySpan;
    private final CascadeStyle[] cascade;
    private final FetchMode[] joinedFetch;
    private final boolean isKey;
    protected final EntityModeToTuplizerMapping tuplizerMapping;

    public ComponentType(ComponentMetamodel metamodel) {
        this.isKey = metamodel.isKey();
        this.propertySpan = metamodel.getPropertySpan();
        this.propertyNames = new String[this.propertySpan];
        this.propertyTypes = new Type[this.propertySpan];
        this.propertyNullability = new boolean[this.propertySpan];
        this.cascade = new CascadeStyle[this.propertySpan];
        this.joinedFetch = new FetchMode[this.propertySpan];
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            StandardProperty prop = metamodel.getProperty(i2);
            this.propertyNames[i2] = prop.getName();
            this.propertyTypes[i2] = prop.getType();
            this.propertyNullability[i2] = prop.isNullable();
            this.cascade[i2] = prop.getCascadeStyle();
            this.joinedFetch[i2] = prop.getFetchMode();
        }
        this.tuplizerMapping = metamodel.getTuplizerMapping();
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        int[] sqlTypes = new int[this.getColumnSpan(mapping)];
        int n2 = 0;
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            int[] subtypes = this.propertyTypes[i2].sqlTypes(mapping);
            for (int j2 = 0; j2 < subtypes.length; ++j2) {
                sqlTypes[n2++] = subtypes[j2];
            }
        }
        return sqlTypes;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        int span = 0;
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            span += this.propertyTypes[i2].getColumnSpan(mapping);
        }
        return span;
    }

    public final boolean isComponentType() {
        return true;
    }

    public Class getReturnedClass() {
        return this.tuplizerMapping.getTuplizer(EntityMode.POJO).getMappedClass();
    }

    public boolean isSame(Object x, Object y, EntityMode entityMode) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Object[] xvalues = this.getPropertyValues(x, entityMode);
        Object[] yvalues = this.getPropertyValues(y, entityMode);
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            if (this.propertyTypes[i2].isSame(xvalues[i2], yvalues[i2], entityMode)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Object[] xvalues = this.getPropertyValues(x, entityMode);
        Object[] yvalues = this.getPropertyValues(y, entityMode);
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            if (this.propertyTypes[i2].isEqual(xvalues[i2], yvalues[i2], entityMode)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(Object x, Object y, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        Object[] xvalues = this.getPropertyValues(x, entityMode);
        Object[] yvalues = this.getPropertyValues(y, entityMode);
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            if (this.propertyTypes[i2].isEqual(xvalues[i2], yvalues[i2], entityMode, factory)) continue;
            return false;
        }
        return true;
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        if (x == y) {
            return 0;
        }
        Object[] xvalues = this.getPropertyValues(x, entityMode);
        Object[] yvalues = this.getPropertyValues(y, entityMode);
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            int propertyCompare = this.propertyTypes[i2].compare(xvalues[i2], yvalues[i2], entityMode);
            if (propertyCompare == 0) continue;
            return propertyCompare;
        }
        return 0;
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        int result = 17;
        Object[] values = this.getPropertyValues(x, entityMode);
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            Object y = values[i2];
            result *= 37;
            if (y == null) continue;
            result += this.propertyTypes[i2].getHashCode(y, entityMode);
        }
        return result;
    }

    public int getHashCode(Object x, EntityMode entityMode, SessionFactoryImplementor factory) {
        int result = 17;
        Object[] values = this.getPropertyValues(x, entityMode);
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            Object y = values[i2];
            result *= 37;
            if (y == null) continue;
            result += this.propertyTypes[i2].getHashCode(y, entityMode, factory);
        }
        return result;
    }

    public boolean isDirty(Object x, Object y, SessionImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        if (x == null || y == null) {
            return true;
        }
        EntityMode entityMode = session.getEntityMode();
        Object[] xvalues = this.getPropertyValues(x, entityMode);
        Object[] yvalues = this.getPropertyValues(y, entityMode);
        for (int i2 = 0; i2 < xvalues.length; ++i2) {
            if (!this.propertyTypes[i2].isDirty(xvalues[i2], yvalues[i2], session)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(Object x, Object y, boolean[] checkable, SessionImplementor session) throws HibernateException {
        if (x == y) {
            return false;
        }
        if (x == null || y == null) {
            return true;
        }
        EntityMode entityMode = session.getEntityMode();
        Object[] xvalues = this.getPropertyValues(x, entityMode);
        Object[] yvalues = this.getPropertyValues(y, entityMode);
        int loc = 0;
        for (int i2 = 0; i2 < xvalues.length; ++i2) {
            int len = this.propertyTypes[i2].getColumnSpan(session.getFactory());
            if (len <= 1) {
                boolean dirty;
                boolean bl = dirty = (len == 0 || checkable[loc]) && this.propertyTypes[i2].isDirty(xvalues[i2], yvalues[i2], session);
                if (dirty) {
                    return true;
                }
            } else {
                boolean[] subcheckable = new boolean[len];
                System.arraycopy(checkable, loc, subcheckable, 0, len);
                boolean dirty = this.propertyTypes[i2].isDirty(xvalues[i2], yvalues[i2], subcheckable, session);
                if (dirty) {
                    return true;
                }
            }
            loc += len;
        }
        return false;
    }

    public boolean isModified(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return current != null;
        }
        Object[] currentValues = this.getPropertyValues(current, session);
        Object[] oldValues = (Object[])old;
        int loc = 0;
        for (int i2 = 0; i2 < currentValues.length; ++i2) {
            int len = this.propertyTypes[i2].getColumnSpan(session.getFactory());
            boolean[] subcheckable = new boolean[len];
            System.arraycopy(checkable, loc, subcheckable, 0, len);
            if (this.propertyTypes[i2].isModified(oldValues[i2], currentValues[i2], subcheckable, session)) {
                return true;
            }
            loc += len;
        }
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolve(this.hydrate(rs, names, session, owner), session, owner);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value, session.getEntityMode());
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            this.propertyTypes[i2].nullSafeSet(st, subvalues[i2], begin, session);
            begin += this.propertyTypes[i2].getColumnSpan(session.getFactory());
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int begin, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        Object[] subvalues = this.nullSafeGetValues(value, session.getEntityMode());
        int loc = 0;
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            int len = this.propertyTypes[i2].getColumnSpan(session.getFactory());
            if (len != 0) {
                if (len == 1) {
                    if (settable[loc]) {
                        this.propertyTypes[i2].nullSafeSet(st, subvalues[i2], begin, session);
                        ++begin;
                    }
                } else {
                    boolean[] subsettable = new boolean[len];
                    System.arraycopy(settable, loc, subsettable, 0, len);
                    this.propertyTypes[i2].nullSafeSet(st, subvalues[i2], begin, subsettable, session);
                    begin += ArrayHelper.countTrue(subsettable);
                }
            }
            loc += len;
        }
    }

    private Object[] nullSafeGetValues(Object value, EntityMode entityMode) throws HibernateException {
        if (value == null) {
            return new Object[this.propertySpan];
        }
        return this.getPropertyValues(value, entityMode);
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    public Object getPropertyValue(Object component, int i2, SessionImplementor session) throws HibernateException {
        return this.getPropertyValue(component, i2, session.getEntityMode());
    }

    public Object getPropertyValue(Object component, int i2, EntityMode entityMode) throws HibernateException {
        return this.tuplizerMapping.getTuplizer(entityMode).getPropertyValue(component, i2);
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        return this.getPropertyValues(component, session.getEntityMode());
    }

    public Object[] getPropertyValues(Object component, EntityMode entityMode) throws HibernateException {
        return this.tuplizerMapping.getTuplizer(entityMode).getPropertyValues(component);
    }

    public void setPropertyValues(Object component, Object[] values, EntityMode entityMode) throws HibernateException {
        this.tuplizerMapping.getTuplizer(entityMode).setPropertyValues(component, values);
    }

    public Type[] getSubtypes() {
        return this.propertyTypes;
    }

    public String getName() {
        return "component" + ArrayHelper.toString(this.propertyNames);
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        HashMap<String, String> result = new HashMap<String, String>();
        EntityMode entityMode = this.tuplizerMapping.guessEntityMode(value);
        if (entityMode == null) {
            throw new ClassCastException(value.getClass().getName());
        }
        Object[] values = this.getPropertyValues(value, entityMode);
        for (int i2 = 0; i2 < this.propertyTypes.length; ++i2) {
            result.put(this.propertyNames[i2], this.propertyTypes[i2].toLoggableString(values[i2], factory));
        }
        return StringHelper.unqualify(this.getName()) + ((Object)result).toString();
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public Object deepCopy(Object component, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        if (component == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(component, entityMode);
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            values[i2] = this.propertyTypes[i2].deepCopy(values[i2], entityMode, factory);
        }
        Object result = this.instantiate(entityMode);
        this.setPropertyValues(result, values, entityMode);
        ComponentTuplizer ct = (ComponentTuplizer)this.tuplizerMapping.getTuplizer(entityMode);
        if (ct.hasParentProperty()) {
            ct.setParent(result, ct.getParent(component), factory);
        }
        return result;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        Object result = target == null ? this.instantiate(owner, session) : target;
        EntityMode entityMode = session.getEntityMode();
        Object[] values = TypeFactory.replace(this.getPropertyValues(original, entityMode), this.getPropertyValues(result, entityMode), this.propertyTypes, session, owner, copyCache);
        this.setPropertyValues(result, values, entityMode);
        return result;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) throws HibernateException {
        if (original == null) {
            return null;
        }
        Object result = target == null ? this.instantiate(owner, session) : target;
        EntityMode entityMode = session.getEntityMode();
        Object[] values = TypeFactory.replace(this.getPropertyValues(original, entityMode), this.getPropertyValues(result, entityMode), this.propertyTypes, session, owner, copyCache, foreignKeyDirection);
        this.setPropertyValues(result, values, entityMode);
        return result;
    }

    public Object instantiate(EntityMode entityMode) throws HibernateException {
        return this.tuplizerMapping.getTuplizer(entityMode).instantiate();
    }

    public Object instantiate(Object parent, SessionImplementor session) throws HibernateException {
        Object result = this.instantiate(session.getEntityMode());
        ComponentTuplizer ct = (ComponentTuplizer)this.tuplizerMapping.getTuplizer(session.getEntityMode());
        if (ct.hasParentProperty() && parent != null) {
            ct.setParent(result, session.getPersistenceContext().proxyFor(parent), session.getFactory());
        }
        return result;
    }

    public CascadeStyle getCascadeStyle(int i2) {
        return this.cascade[i2];
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        Object[] values = this.getPropertyValues(value, session.getEntityMode());
        for (int i2 = 0; i2 < this.propertyTypes.length; ++i2) {
            values[i2] = this.propertyTypes[i2].disassemble(values[i2], session, owner);
        }
        return values;
    }

    public Object assemble(Serializable object, SessionImplementor session, Object owner) throws HibernateException {
        if (object == null) {
            return null;
        }
        Object[] values = (Object[])object;
        Object[] assembled = new Object[values.length];
        for (int i2 = 0; i2 < this.propertyTypes.length; ++i2) {
            assembled[i2] = this.propertyTypes[i2].assemble((Serializable)values[i2], session, owner);
        }
        Object result = this.instantiate(owner, session);
        this.setPropertyValues(result, assembled, session.getEntityMode());
        return result;
    }

    public FetchMode getFetchMode(int i2) {
        return this.joinedFetch[i2];
    }

    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        int begin = 0;
        boolean notNull = false;
        Object[] values = new Object[this.propertySpan];
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            int length = this.propertyTypes[i2].getColumnSpan(session.getFactory());
            String[] range = ArrayHelper.slice(names, begin, length);
            Object val = this.propertyTypes[i2].hydrate(rs, range, session, owner);
            if (val == null) {
                if (this.isKey) {
                    return null;
                }
            } else {
                notNull = true;
            }
            values[i2] = val;
            begin += length;
        }
        return notNull ? values : null;
    }

    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value != null) {
            Object result = this.instantiate(owner, session);
            Object[] values = (Object[])value;
            Object[] resolvedValues = new Object[values.length];
            for (int i2 = 0; i2 < values.length; ++i2) {
                resolvedValues[i2] = this.propertyTypes[i2].resolve(values[i2], session, owner);
            }
            this.setPropertyValues(result, resolvedValues, session.getEntityMode());
            return result;
        }
        return null;
    }

    public Object semiResolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolve(value, session, owner);
    }

    public boolean[] getPropertyNullability() {
        return this.propertyNullability;
    }

    public boolean isXMLElement() {
        return true;
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return xml;
    }

    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        ComponentType.replaceNode(node, (Element)value);
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value == null) {
            return result;
        }
        Object[] values = this.getPropertyValues(value, EntityMode.POJO);
        int loc = 0;
        for (int i2 = 0; i2 < this.propertyTypes.length; ++i2) {
            boolean[] propertyNullness = this.propertyTypes[i2].toColumnNullness(values[i2], mapping);
            System.arraycopy(propertyNullness, 0, result, loc, propertyNullness.length);
            loc += propertyNullness.length;
        }
        return result;
    }

    public boolean isEmbedded() {
        return false;
    }
}

