/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.type.Type;

public final class ArrayHelper {
    public static final boolean[] TRUE = new boolean[]{true};
    public static final boolean[] FALSE = new boolean[]{false};
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    private static int SEED = 23;
    private static int PRIME_NUMER = 37;

    public static int indexOf(Object[] array, Object object) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!array[i2].equals(object)) continue;
            return i2;
        }
        return -1;
    }

    public static String[] toStringArray(Object[] objects) {
        int length = objects.length;
        String[] result = new String[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result[i2] = objects[i2].toString();
        }
        return result;
    }

    public static String[] fillArray(String value, int length) {
        Object[] result = new String[length];
        Arrays.fill(result, value);
        return result;
    }

    public static int[] fillArray(int value, int length) {
        int[] result = new int[length];
        Arrays.fill(result, value);
        return result;
    }

    public static LockMode[] fillArray(LockMode lockMode, int length) {
        Object[] array = new LockMode[length];
        Arrays.fill(array, lockMode);
        return array;
    }

    public static String[] toStringArray(Collection coll) {
        return coll.toArray(EMPTY_STRING_ARRAY);
    }

    public static String[][] to2DStringArray(Collection coll) {
        return (String[][])coll.toArray((T[])new String[coll.size()][]);
    }

    public static int[][] to2DIntArray(Collection coll) {
        return (int[][])coll.toArray((T[])new int[coll.size()][]);
    }

    public static Type[] toTypeArray(Collection coll) {
        return coll.toArray(EMPTY_TYPE_ARRAY);
    }

    public static int[] toIntArray(Collection coll) {
        Iterator iter = coll.iterator();
        int[] arr = new int[coll.size()];
        int i2 = 0;
        while (iter.hasNext()) {
            arr[i2++] = (Integer)iter.next();
        }
        return arr;
    }

    public static boolean[] toBooleanArray(Collection coll) {
        Iterator iter = coll.iterator();
        boolean[] arr = new boolean[coll.size()];
        int i2 = 0;
        while (iter.hasNext()) {
            arr[i2++] = (Boolean)iter.next();
        }
        return arr;
    }

    public static Object[] typecast(Object[] array, Object[] to) {
        return Arrays.asList(array).toArray(to);
    }

    public static List toList(Object array) {
        if (array instanceof Object[]) {
            return Arrays.asList((Object[])array);
        }
        int size = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            list.add(Array.get(array, i2));
        }
        return list;
    }

    public static String[] slice(String[] strings, int begin, int length) {
        String[] result = new String[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result[i2] = strings[begin + i2];
        }
        return result;
    }

    public static Object[] slice(Object[] objects, int begin, int length) {
        Object[] result = new Object[length];
        for (int i2 = 0; i2 < length; ++i2) {
            result[i2] = objects[begin + i2];
        }
        return result;
    }

    public static List toList(Iterator iter) {
        ArrayList list = new ArrayList();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static String[] join(String[] x, String[] y) {
        int i2;
        String[] result = new String[x.length + y.length];
        for (i2 = 0; i2 < x.length; ++i2) {
            result[i2] = x[i2];
        }
        for (i2 = 0; i2 < y.length; ++i2) {
            result[i2 + x.length] = y[i2];
        }
        return result;
    }

    public static String[] join(String[] x, String[] y, boolean[] use) {
        String[] result = new String[x.length + ArrayHelper.countTrue(use)];
        for (int i2 = 0; i2 < x.length; ++i2) {
            result[i2] = x[i2];
        }
        int k2 = x.length;
        for (int i3 = 0; i3 < y.length; ++i3) {
            if (!use[i3]) continue;
            result[k2++] = y[i3];
        }
        return result;
    }

    public static int[] join(int[] x, int[] y) {
        int i2;
        int[] result = new int[x.length + y.length];
        for (i2 = 0; i2 < x.length; ++i2) {
            result[i2] = x[i2];
        }
        for (i2 = 0; i2 < y.length; ++i2) {
            result[i2 + x.length] = y[i2];
        }
        return result;
    }

    private ArrayHelper() {
    }

    public static String toString(Object[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i2 = 0; i2 < array.length; ++i2) {
            sb.append(array[i2]);
            if (i2 >= array.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isAllNegative(int[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllTrue(boolean[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2]) continue;
            return false;
        }
        return true;
    }

    public static int countTrue(boolean[] array) {
        int result = 0;
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!array[i2]) continue;
            ++result;
        }
        return result;
    }

    public static boolean isAllFalse(boolean[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (!array[i2]) continue;
            return false;
        }
        return true;
    }

    public static void addAll(Collection collection, Object[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            collection.add(array[i2]);
        }
    }

    public static int[] getBatchSizes(int maxBatchSize) {
        int batchSize = maxBatchSize;
        int n2 = 1;
        while (batchSize > 1) {
            batchSize = ArrayHelper.getNextBatchSize(batchSize);
            ++n2;
        }
        int[] result = new int[n2];
        batchSize = maxBatchSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            result[i2] = batchSize;
            batchSize = ArrayHelper.getNextBatchSize(batchSize);
        }
        return result;
    }

    private static int getNextBatchSize(int batchSize) {
        if (batchSize <= 10) {
            return batchSize - 1;
        }
        if (batchSize / 2 < 10) {
            return 10;
        }
        return batchSize / 2;
    }

    public static int hash(Object[] array) {
        int length = array.length;
        int seed = SEED;
        for (int index = 0; index < length; ++index) {
            seed = ArrayHelper.hash(seed, array[index] == null ? 0 : array[index].hashCode());
        }
        return seed;
    }

    public static int hash(char[] array) {
        int length = array.length;
        int seed = SEED;
        for (int index = 0; index < length; ++index) {
            seed = ArrayHelper.hash(seed, array[index]);
        }
        return seed;
    }

    public static int hash(byte[] bytes) {
        int length = bytes.length;
        int seed = SEED;
        for (int index = 0; index < length; ++index) {
            seed = ArrayHelper.hash(seed, bytes[index]);
        }
        return seed;
    }

    private static int hash(int seed, int i2) {
        return PRIME_NUMER * seed + i2;
    }

    public static boolean isEquals(Object[] o1, Object[] o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        int length = o1.length;
        if (length != o2.length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (o1[index].equals(o2[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(char[] o1, char[] o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        int length = o1.length;
        if (length != o2.length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (o1[index] == o2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(byte[] b1, byte[] b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        int length = b1.length;
        if (length != b2.length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (b1[index] == b2[index]) continue;
            return false;
        }
        return true;
    }
}

