/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.sql.Template;
import org.hibernate.util.StringHelper;

public class FilterHelper {
    private final String[] filterNames;
    private final String[] filterConditions;

    public FilterHelper(Map filters, Dialect dialect, SQLFunctionRegistry functionRegistry) {
        int filterCount = filters.size();
        this.filterNames = new String[filterCount];
        this.filterConditions = new String[filterCount];
        Iterator iter = filters.entrySet().iterator();
        filterCount = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.filterNames[filterCount] = (String)entry.getKey();
            this.filterConditions[filterCount] = Template.renderWhereStringTemplate((String)entry.getValue(), "$FILTER_PLACEHOLDER$", dialect, functionRegistry);
            this.filterConditions[filterCount] = StringHelper.replace(this.filterConditions[filterCount], ":", ":" + this.filterNames[filterCount] + ".");
            ++filterCount;
        }
    }

    public boolean isAffectedBy(Map enabledFilters) {
        int max = this.filterNames.length;
        for (int i2 = 0; i2 < max; ++i2) {
            if (!enabledFilters.containsKey(this.filterNames[i2])) continue;
            return true;
        }
        return false;
    }

    public String render(String alias, Map enabledFilters) {
        StringBuffer buffer = new StringBuffer();
        this.render(buffer, alias, enabledFilters);
        return buffer.toString();
    }

    public void render(StringBuffer buffer, String alias, Map enabledFilters) {
        if (this.filterNames != null && this.filterNames.length > 0) {
            int max = this.filterNames.length;
            for (int i2 = 0; i2 < max; ++i2) {
                String condition;
                if (!enabledFilters.containsKey(this.filterNames[i2]) || !StringHelper.isNotEmpty(condition = this.filterConditions[i2])) continue;
                buffer.append(" and ").append(StringHelper.replace(condition, "$FILTER_PLACEHOLDER$", alias));
            }
        }
    }
}

