/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import [Ljava.lang.String;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.AssertionFailure;

public class NamedGeneratedKeysHelper {
    private static final Method PREPARE_STATEMENT_METHOD;
    private static final Method GET_GENERATED_KEYS_METHOD;

    private NamedGeneratedKeysHelper() {
    }

    public static PreparedStatement prepareStatement(Connection conn, String sql, String[] columnNames) throws SQLException {
        Object[] args = new Object[]{sql, columnNames};
        try {
            return (PreparedStatement)PREPARE_STATEMENT_METHOD.invoke((Object)conn, args);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof SQLException) {
                throw (SQLException)ite.getTargetException();
            }
            if (ite.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ite.getTargetException();
            }
            throw new AssertionFailure("InvocationTargetException preparing statement capable of returning generated keys (JDBC3)", ite);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionFailure("IllegalAccessException preparing statement capable of returning generated keys (JDBC3)", iae);
        }
    }

    public static ResultSet getGeneratedKey(PreparedStatement ps) throws SQLException {
        try {
            return (ResultSet)GET_GENERATED_KEYS_METHOD.invoke((Object)ps, null);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof SQLException) {
                throw (SQLException)ite.getTargetException();
            }
            if (ite.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ite.getTargetException();
            }
            throw new AssertionFailure("InvocationTargetException extracting generated keys (JDBC3)", ite);
        }
        catch (IllegalAccessException iae) {
            throw new AssertionFailure("IllegalAccessException extracting generated keys (JDBC3)", iae);
        }
    }

    static {
        try {
            PREPARE_STATEMENT_METHOD = Connection.class.getMethod("prepareStatement", String.class, String;.class);
            GET_GENERATED_KEYS_METHOD = Statement.class.getDeclaredMethod("getGeneratedKeys", null);
        }
        catch (Exception e2) {
            throw new AssertionFailure("could not initialize getGeneratedKeys() support", e2);
        }
    }
}

