/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.type.SerializationException;

public final class SerializationHelper {
    private static final Log log = LogFactory.getLog(SerializationHelper.class);

    private SerializationHelper() {
    }

    public static Object clone(Serializable object) throws SerializationException {
        log.trace("Starting clone through serialization");
        return SerializationHelper.deserialize(SerializationHelper.serialize(object));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Serializable obj, OutputStream outputStream) throws SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        if (log.isTraceEnabled()) {
            if (Hibernate.isInitialized(obj)) {
                log.trace("Starting serialization of object [" + obj + "]");
            } else {
                log.trace("Starting serialization of [uninitialized proxy]");
            }
        }
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(outputStream);
                out.writeObject(obj);
            }
            catch (IOException ex) {
                throw new SerializationException("could not serialize", ex);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        if (out == null) return;
        out.close();
        return;
    }

    public static byte[] serialize(Serializable obj) throws SerializationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationHelper.serialize(obj, baos);
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(InputStream inputStream) throws SerializationException {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        log.trace("Starting deserialization of object");
        CustomObjectInputStream in = null;
        try {
            try {
                in = new CustomObjectInputStream(inputStream);
                object = in.readObject();
                Object var4_5 = null;
            }
            catch (ClassNotFoundException ex) {
                throw new SerializationException("could not deserialize", ex);
            }
            catch (IOException ex) {
                throw new SerializationException("could not deserialize", ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ex) {
            // empty catch block
            return object;
        }
        if (in == null) return object;
        in.close();
        return object;
    }

    public static Object deserialize(byte[] objectData) throws SerializationException {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        return SerializationHelper.deserialize(bais);
    }

    private static final class CustomObjectInputStream
    extends ObjectInputStream {
        public CustomObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String className = v.getName();
            Class<?> resolvedClass = null;
            log.trace("Attempting to locate class [" + className + "]");
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                resolvedClass = loader.loadClass(className);
                log.trace("Class resolved through context class loader");
            }
            catch (ClassNotFoundException e2) {
                log.trace("Asking super to resolve");
                resolvedClass = super.resolveClass(v);
            }
            return resolvedClass;
        }
    }
}

