/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import org.jfree.data.xy.XYDataset;

public abstract class Regression {
    public static double[] getOLSRegression(double[][] data) {
        int n2 = data.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double x = data[i2][0];
            double y = data[i2][1];
            sumX += x;
            sumY += y;
            double xx = x * x;
            sumXX += xx;
            double xy = x * y;
            sumXY += xy;
        }
        double sxx = sumXX - sumX * sumX / (double)n2;
        double sxy = sumXY - sumX * sumY / (double)n2;
        double xbar = sumX / (double)n2;
        double ybar = sumY / (double)n2;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = ybar - result[1] * xbar;
        return result;
    }

    public static double[] getOLSRegression(XYDataset data, int series) {
        int n2 = data.getItemCount(series);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double x = data.getXValue(series, i2);
            double y = data.getYValue(series, i2);
            sumX += x;
            sumY += y;
            double xx = x * x;
            sumXX += xx;
            double xy = x * y;
            sumXY += xy;
        }
        double sxx = sumXX - sumX * sumX / (double)n2;
        double sxy = sumXY - sumX * sumY / (double)n2;
        double xbar = sumX / (double)n2;
        double ybar = sumY / (double)n2;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = ybar - result[1] * xbar;
        return result;
    }

    public static double[] getPowerRegression(double[][] data) {
        int n2 = data.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double x = Math.log(data[i2][0]);
            double y = Math.log(data[i2][1]);
            sumX += x;
            sumY += y;
            double xx = x * x;
            sumXX += xx;
            double xy = x * y;
            sumXY += xy;
        }
        double sxx = sumXX - sumX * sumX / (double)n2;
        double sxy = sumXY - sumX * sumY / (double)n2;
        double xbar = sumX / (double)n2;
        double ybar = sumY / (double)n2;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = Math.pow(Math.exp(1.0), ybar - result[1] * xbar);
        return result;
    }

    public static double[] getPowerRegression(XYDataset data, int series) {
        int n2 = data.getItemCount(series);
        if (n2 < 2) {
            throw new IllegalArgumentException("Not enough data.");
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double x = Math.log(data.getXValue(series, i2));
            double y = Math.log(data.getYValue(series, i2));
            sumX += x;
            sumY += y;
            double xx = x * x;
            sumXX += xx;
            double xy = x * y;
            sumXY += xy;
        }
        double sxx = sumXX - sumX * sumX / (double)n2;
        double sxy = sumXY - sumX * sumY / (double)n2;
        double xbar = sumX / (double)n2;
        double ybar = sumY / (double)n2;
        double[] result = new double[2];
        result[1] = sxy / sxx;
        result[0] = Math.pow(Math.exp(1.0), ybar - result[1] * xbar);
        return result;
    }
}

