/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class LCBLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -2531780832406163833L;
    private static final int COLUMNS = 3;
    private int[] colWidth = new int[3];
    private int[] rowHeight;
    private int labelGap = 10;
    private int buttonGap = 6;
    private int vGap = 2;

    public LCBLayout(int maxrows) {
        this.rowHeight = new int[maxrows];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            for (int c2 = 0; c2 < 3; ++c2) {
                for (r = 0; r < nrows; ++r) {
                    Component component = parent.getComponent(r * 3 + c2);
                    Dimension d2 = component.getPreferredSize();
                    if (this.colWidth[c2] < d2.width) {
                        this.colWidth[c2] = d2.width;
                    }
                    if (this.rowHeight[r] >= d2.height) continue;
                    this.rowHeight[r] = d2.height;
                }
            }
            int totalHeight = this.vGap * (nrows - 1);
            for (r = 0; r < nrows; ++r) {
                totalHeight += this.rowHeight[r];
            }
            int totalWidth = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            return new Dimension(insets.left + insets.right + totalWidth + this.labelGap + this.buttonGap, insets.top + insets.bottom + totalHeight + this.vGap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            for (int c2 = 0; c2 < 3; ++c2) {
                for (r = 0; r < nrows; ++r) {
                    Component component = parent.getComponent(r * 3 + c2);
                    Dimension d2 = component.getMinimumSize();
                    if (this.colWidth[c2] < d2.width) {
                        this.colWidth[c2] = d2.width;
                    }
                    if (this.rowHeight[r] >= d2.height) continue;
                    this.rowHeight[r] = d2.height;
                }
            }
            int totalHeight = this.vGap * (nrows - 1);
            for (r = 0; r < nrows; ++r) {
                totalHeight += this.rowHeight[r];
            }
            int totalWidth = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            return new Dimension(insets.left + insets.right + totalWidth + this.labelGap + this.buttonGap, insets.top + insets.bottom + totalHeight + this.vGap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int r;
            Insets insets = parent.getInsets();
            int ncomponents = parent.getComponentCount();
            int nrows = ncomponents / 3;
            for (int c2 = 0; c2 < 3; ++c2) {
                for (r = 0; r < nrows; ++r) {
                    Component component = parent.getComponent(r * 3 + c2);
                    Dimension d2 = component.getPreferredSize();
                    if (this.colWidth[c2] < d2.width) {
                        this.colWidth[c2] = d2.width;
                    }
                    if (this.rowHeight[r] >= d2.height) continue;
                    this.rowHeight[r] = d2.height;
                }
            }
            int totalHeight = this.vGap * (nrows - 1);
            for (r = 0; r < nrows; ++r) {
                totalHeight += this.rowHeight[r];
            }
            int totalWidth = this.colWidth[0] + this.colWidth[1] + this.colWidth[2];
            int available = parent.getWidth() - insets.left - insets.right - this.labelGap - this.buttonGap;
            this.colWidth[1] = this.colWidth[1] + (available - totalWidth);
            int x = insets.left;
            for (int c3 = 0; c3 < 3; ++c3) {
                int y = insets.top;
                for (int r2 = 0; r2 < nrows; ++r2) {
                    int i2 = r2 * 3 + c3;
                    if (i2 < ncomponents) {
                        Component component = parent.getComponent(i2);
                        Dimension d3 = component.getPreferredSize();
                        int h2 = d3.height;
                        int adjust = (this.rowHeight[r2] - h2) / 2;
                        parent.getComponent(i2).setBounds(x, y + adjust, this.colWidth[c3], h2);
                    }
                    y = y + this.rowHeight[r2] + this.vGap;
                }
                x += this.colWidth[c3];
                if (c3 == 0) {
                    x += this.labelGap;
                }
                if (c3 != 1) continue;
                x += this.buttonGap;
            }
        }
    }

    public void addLayoutComponent(Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(String name, Component comp) {
    }
}

