/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.jfree.util.Log;

public class ActionButton
extends JButton {
    private Action action;
    private ActionEnablePropertyChangeHandler propertyChangeHandler;

    public ActionButton() {
    }

    public ActionButton(String text) {
        super(text);
    }

    public ActionButton(String text, Icon icon) {
        super(text, icon);
    }

    public ActionButton(Icon icon) {
        super(icon);
    }

    public ActionButton(Action action) {
        this.setAction(action);
    }

    public Action getAction() {
        return this.action;
    }

    private ActionEnablePropertyChangeHandler getPropertyChangeHandler() {
        if (this.propertyChangeHandler == null) {
            this.propertyChangeHandler = new ActionEnablePropertyChangeHandler();
        }
        return this.propertyChangeHandler;
    }

    public void setEnabled(boolean b2) {
        super.setEnabled(b2);
        if (this.getAction() != null) {
            this.getAction().setEnabled(b2);
        }
    }

    public void setAction(Action newAction) {
        KeyStroke k2;
        Object o2;
        Action oldAction = this.getAction();
        if (oldAction != null) {
            this.removeActionListener(oldAction);
            oldAction.removePropertyChangeListener(this.getPropertyChangeHandler());
            o2 = oldAction.getValue("AcceleratorKey");
            if (o2 instanceof KeyStroke) {
                k2 = (KeyStroke)o2;
                this.unregisterKeyboardAction(k2);
            }
        }
        this.action = newAction;
        if (this.action != null) {
            this.addActionListener(newAction);
            newAction.addPropertyChangeListener(this.getPropertyChangeHandler());
            this.setText((String)newAction.getValue("Name"));
            this.setToolTipText((String)newAction.getValue("ShortDescription"));
            this.setIcon((Icon)newAction.getValue("SmallIcon"));
            this.setEnabled(this.action.isEnabled());
            o2 = newAction.getValue("MnemonicKey");
            if (o2 != null) {
                Comparable<Character> c2;
                if (o2 instanceof Character) {
                    c2 = (Character)o2;
                    this.setMnemonic(((Character)c2).charValue());
                } else if (o2 instanceof Integer) {
                    c2 = (Integer)o2;
                    this.setMnemonic((Integer)c2);
                }
            }
            if ((o2 = newAction.getValue("AcceleratorKey")) instanceof KeyStroke) {
                k2 = (KeyStroke)o2;
                this.registerKeyboardAction(newAction, k2, 2);
            }
        }
    }

    private class ActionEnablePropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            try {
                Object o2;
                if (event.getPropertyName().equals("enabled")) {
                    ActionButton.this.setEnabled(ActionButton.this.getAction().isEnabled());
                } else if (event.getPropertyName().equals("SmallIcon")) {
                    ActionButton.this.setIcon((Icon)ActionButton.this.getAction().getValue("SmallIcon"));
                } else if (event.getPropertyName().equals("Name")) {
                    ActionButton.this.setText((String)ActionButton.this.getAction().getValue("Name"));
                } else if (event.getPropertyName().equals("ShortDescription")) {
                    ActionButton.this.setToolTipText((String)ActionButton.this.getAction().getValue("ShortDescription"));
                }
                Action ac = ActionButton.this.getAction();
                if (event.getPropertyName().equals("AcceleratorKey")) {
                    Object o3;
                    KeyStroke oldVal = (KeyStroke)event.getOldValue();
                    if (oldVal != null) {
                        ActionButton.this.unregisterKeyboardAction(oldVal);
                    }
                    if ((o3 = ac.getValue("AcceleratorKey")) instanceof KeyStroke) {
                        KeyStroke k2 = (KeyStroke)o3;
                        ActionButton.this.registerKeyboardAction(ac, k2, 2);
                    }
                } else if (event.getPropertyName().equals("MnemonicKey") && (o2 = ac.getValue("MnemonicKey")) != null) {
                    if (o2 instanceof Character) {
                        Character c2 = (Character)o2;
                        ActionButton.this.setMnemonic(c2.charValue());
                    } else if (o2 instanceof Integer) {
                        Integer c3 = (Integer)o2;
                        ActionButton.this.setMnemonic(c3);
                    }
                }
            }
            catch (Exception e2) {
                Log.warn("Error on PropertyChange in ActionButton: ", e2);
            }
        }
    }
}

