/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Stack;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.CallbackEvaluationI;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.SpecialEvaluationI;

public class EvaluatorVisitor
implements ParserVisitor,
EvaluatorI {
    protected Stack stack = new Stack();
    protected SymbolTable symTab = null;
    protected static final boolean debug = false;
    protected boolean trapNullValues = true;

    public Object getValue(Node node, SymbolTable symbolTable) throws ParseException {
        if (node == null) {
            throw new ParseException("topNode parameter is null");
        }
        this.symTab = symbolTable;
        this.stack.removeAllElements();
        node.jjtAccept(this, null);
        if (this.stack.size() != 1) {
            throw new ParseException("Stack corrupted");
        }
        return this.stack.pop();
    }

    public Object eval(Node node) throws ParseException {
        node.jjtAccept(this, null);
        return this.stack.pop();
    }

    public Object eval(PostfixMathCommandI postfixMathCommandI, Node[] nodeArray) throws ParseException {
        if (postfixMathCommandI instanceof SpecialEvaluationI) {
            ASTFunNode aSTFunNode = new ASTFunNode(2);
            aSTFunNode.setFunction("TmpFun", postfixMathCommandI);
            aSTFunNode.jjtOpen();
            for (int i2 = 0; i2 < nodeArray.length; ++i2) {
                aSTFunNode.jjtAddChild(nodeArray[i2], i2);
            }
            aSTFunNode.jjtClose();
            return ((SpecialEvaluationI)((Object)postfixMathCommandI)).evaluate(aSTFunNode, null, this, new Stack(), this.symTab);
        }
        if (postfixMathCommandI instanceof CallbackEvaluationI) {
            ASTFunNode aSTFunNode = new ASTFunNode(2);
            aSTFunNode.setFunction("TmpFun", postfixMathCommandI);
            aSTFunNode.jjtOpen();
            for (int i3 = 0; i3 < nodeArray.length; ++i3) {
                aSTFunNode.jjtAddChild(nodeArray[i3], i3);
            }
            aSTFunNode.jjtClose();
            Object object = ((CallbackEvaluationI)((Object)postfixMathCommandI)).evaluate(aSTFunNode, this);
            return object;
        }
        Stack<Object> stack = new Stack<Object>();
        for (int i4 = 0; i4 < nodeArray.length; ++i4) {
            if (!(nodeArray[i4] instanceof ASTConstant)) {
                throw new ParseException("buildConstantNode: arguments must all be constant nodes");
            }
            stack.push(((ASTConstant)nodeArray[i4]).getValue());
        }
        postfixMathCommandI.setCurNumberOfParameters(nodeArray.length);
        postfixMathCommandI.run(stack);
        return stack.pop();
    }

    public Object visit(SimpleNode simpleNode, Object object) throws ParseException {
        throw new ParseException("No visit method for " + simpleNode.getClass().getName());
    }

    public Object visit(ASTStart aSTStart, Object object) throws ParseException {
        throw new ParseException("Start node encountered during evaluation");
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        if (aSTFunNode == null) {
            return null;
        }
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (postfixMathCommandI == null) {
            throw new ParseException("No function class associated with " + aSTFunNode.getName());
        }
        if (postfixMathCommandI instanceof SpecialEvaluationI) {
            return ((SpecialEvaluationI)((Object)postfixMathCommandI)).evaluate(aSTFunNode, object, this, this.stack, this.symTab);
        }
        if (postfixMathCommandI instanceof CallbackEvaluationI) {
            Object object2 = ((CallbackEvaluationI)((Object)postfixMathCommandI)).evaluate(aSTFunNode, this);
            this.stack.push(object2);
            return object2;
        }
        object = aSTFunNode.childrenAccept(this, object);
        if (postfixMathCommandI.getNumberOfParameters() == -1) {
            postfixMathCommandI.setCurNumberOfParameters(aSTFunNode.jjtGetNumChildren());
        }
        postfixMathCommandI.run(this.stack);
        return object;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        Variable variable = aSTVarNode.getVar();
        if (variable == null) {
            String string = "Could not evaluate " + aSTVarNode.getName() + ": ";
            throw new ParseException(string + "the variable was not found in the symbol table");
        }
        Object object2 = variable.getValue();
        if (this.trapNullValues && object2 == null) {
            String string = "Could not evaluate " + aSTVarNode.getName() + ": ";
            throw new ParseException(string + "variable not set");
        }
        this.stack.push(object2);
        return object;
    }

    public Object visit(ASTConstant aSTConstant, Object object) {
        this.stack.push(aSTConstant.getValue());
        return object;
    }

    public boolean isTrapNullValues() {
        return this.trapNullValues;
    }

    public void setTrapNullValues(boolean bl) {
        this.trapNullValues = bl;
    }
}

