/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.evaluation;

import java.util.Stack;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.evaluation.CommandElement;
import org.nfunk.jep.function.PostfixMathCommandI;

public class CommandEvaluator {
    private CommandElement command;
    private Stack stack = new Stack();
    private PostfixMathCommandI pfmc;
    private int i;

    public Object evaluate(CommandElement[] commandElementArray, SymbolTable symbolTable) throws Exception {
        int n2 = commandElementArray.length;
        this.stack.removeAllElements();
        this.i = 0;
        while (this.i < n2) {
            this.command = commandElementArray[this.i];
            switch (this.command.getType()) {
                case 2: {
                    this.pfmc = this.command.getPFMC();
                    this.pfmc.setCurNumberOfParameters(this.command.getNumParam());
                    this.pfmc.run(this.stack);
                    break;
                }
                case 0: {
                    this.stack.push(symbolTable.getValue(this.command.getVarName()));
                    break;
                }
                default: {
                    this.stack.push(this.command.getValue());
                }
            }
            ++this.i;
        }
        if (this.stack.size() != 1) {
            throw new Exception("CommandEvaluator.evaluate(): Stack size is not 1");
        }
        return this.stack.pop();
    }
}

