/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class ArcSineH
extends PostfixMathCommand {
    public ArcSineH() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        stack.push(this.asinh(e2));
    }

    public Object asinh(Object object) throws ParseException {
        if (object instanceof Complex) {
            return ((Complex)object).asinh();
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            double d3 = Math.log(d2 + Math.sqrt(d2 * d2 + 1.0));
            return new Double(d3);
        }
        throw new ParseException("Invalid parameter type");
    }
}

