/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class ArcTanH
extends PostfixMathCommand {
    public ArcTanH() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        stack.push(this.atanh(e2));
    }

    public Object atanh(Object object) throws ParseException {
        if (object instanceof Complex) {
            return ((Complex)object).atanh();
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            if (d2 > -1.0 && d2 < 1.0) {
                double d3 = Math.log((1.0 + d2) / (1.0 - d2)) / 2.0;
                return new Double(d3);
            }
            Complex complex = new Complex(d2, 0.0);
            return complex.atanh();
        }
        throw new ParseException("Invalid parameter type");
    }
}

