/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ArcTangent2
extends PostfixMathCommand {
    public ArcTangent2() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        Object e3 = stack.pop();
        if (!(e3 instanceof Number) || !(e2 instanceof Number)) {
            throw new ParseException("Invalid parameter type");
        }
        double d2 = ((Number)e3).doubleValue();
        double d3 = ((Number)e2).doubleValue();
        stack.push(new Double(Math.atan2(d2, d3)));
    }
}

