/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Binomial
extends PostfixMathCommand {
    static final int initN = 20;
    static int[][] coeffs = new int[21][];

    static void expand(int n2) {
        int n3;
        int n4 = coeffs.length - 1;
        if (n2 <= n4) {
            return;
        }
        int[][] nArrayArray = new int[n2 + 1][];
        for (n3 = 0; n3 <= n4; ++n3) {
            nArrayArray[n3] = coeffs[n3];
        }
        for (n3 = n4 + 1; n3 <= n2; ++n3) {
            nArrayArray[n3] = new int[n3 + 1];
            nArrayArray[n3][0] = 1;
            nArrayArray[n3][n3] = 1;
            for (int i2 = 1; i2 < n3; ++i2) {
                nArrayArray[n3][i2] = nArrayArray[n3 - 1][i2 - 1] + nArrayArray[n3 - 1][i2];
            }
        }
        coeffs = nArrayArray;
    }

    public Binomial() {
        Binomial.coeffs[0] = new int[1];
        Binomial.coeffs[0][0] = 1;
        Binomial.coeffs[1] = new int[2];
        Binomial.coeffs[1][0] = 1;
        Binomial.coeffs[1][1] = 1;
        for (int i2 = 2; i2 <= 20; ++i2) {
            Binomial.coeffs[i2] = new int[i2 + 1];
            Binomial.coeffs[i2][0] = 1;
            Binomial.coeffs[i2][i2] = 1;
            for (int i3 = 1; i3 < i2; ++i3) {
                Binomial.coeffs[i2][i3] = coeffs[i2 - 1][i3 - 1] + coeffs[i2 - 1][i3];
            }
        }
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        Object e2 = stack.pop();
        Object e3 = stack.pop();
        if (!(e2 instanceof Number) || !(e3 instanceof Number)) {
            throw new ParseException("Binomial: both arguments must be integers. They are " + e3 + "(" + e3.getClass().getName() + ") and " + e2 + "(" + e3.getClass().getName() + ")");
        }
        int n2 = ((Number)e2).intValue();
        int n3 = ((Number)e3).intValue();
        if (n3 < 0 || n2 < 0 || n2 > n3) {
            throw new ParseException("Binomial: illegal values for arguments 0<i<n. They are " + e3 + " and " + e2);
        }
        Binomial.expand(n3);
        int n4 = coeffs[n3][n2];
        stack.push(new Integer(n4));
    }

    public static int binom(int n2, int n3) throws ArrayIndexOutOfBoundsException {
        Binomial.expand(n2);
        return coeffs[n2][n3];
    }
}

