/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Comparative
extends PostfixMathCommand {
    protected int id;
    double tolerance;
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int LE = 2;
    public static final int GE = 3;
    public static final int NE = 4;
    public static final int EQ = 5;

    public Comparative(int n2) {
        this.id = n2;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        Object e3 = stack.pop();
        boolean bl = false;
        switch (this.id) {
            case 0: {
                bl = this.lt(e3, e2);
                break;
            }
            case 1: {
                bl = this.gt(e3, e2);
                break;
            }
            case 2: {
                bl = this.le(e3, e2);
                break;
            }
            case 3: {
                bl = this.ge(e3, e2);
                break;
            }
            case 4: {
                bl = this.ne(e3, e2);
                break;
            }
            case 5: {
                bl = this.eq(e3, e2);
            }
        }
        if (bl) {
            stack.push(new Double(1.0));
        } else {
            stack.push(new Double(0.0));
        }
    }

    public boolean lt(Object object, Object object2) throws ParseException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new ParseException("< not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            return d3 < (d2 = ((Number)object2).doubleValue());
        }
        throw new ParseException("< not defined for object of type " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    public boolean gt(Object object, Object object2) throws ParseException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new ParseException("> not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            return d3 > (d2 = ((Number)object2).doubleValue());
        }
        throw new ParseException("> not defined for object of type " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    public boolean le(Object object, Object object2) throws ParseException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new ParseException("<= not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            return d3 <= (d2 = ((Number)object2).doubleValue());
        }
        throw new ParseException("<= not defined for object of type " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    public boolean ge(Object object, Object object2) throws ParseException {
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new ParseException(">= not defined for complex numbers");
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            return d3 >= (d2 = ((Number)object2).doubleValue());
        }
        throw new ParseException(">= not defined for object of type " + object.getClass().getName() + " and " + object2.getClass().getName());
    }

    public boolean eq(Object object, Object object2) throws ParseException {
        if (object instanceof Complex && object2 instanceof Complex) {
            return ((Complex)object).equals((Complex)object2, this.tolerance);
        }
        if (object instanceof Complex && object2 instanceof Number) {
            return ((Complex)object).equals(new Complex((Number)object2), this.tolerance);
        }
        if (object2 instanceof Complex && object instanceof Number) {
            return ((Complex)object2).equals(new Complex((Number)object), this.tolerance);
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            return d3 == (d2 = ((Number)object2).doubleValue());
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = (Boolean)object;
            return bl2 == (bl = ((Boolean)object2).booleanValue());
        }
        if (object instanceof Number && object2 instanceof Boolean) {
            double d4 = ((Number)object).doubleValue();
            double d5 = (Boolean)object2 != false ? 1.0 : 0.0;
            return d4 == d5;
        }
        if (object instanceof Boolean && object2 instanceof Number) {
            double d6 = (Boolean)object != false ? 1.0 : 0.0;
            double d7 = ((Number)object2).doubleValue();
            return d6 == d7;
        }
        return object.equals(object2);
    }

    public boolean ne(Object object, Object object2) throws ParseException {
        if (object instanceof Complex && object2 instanceof Complex) {
            return !((Complex)object).equals((Complex)object2, this.tolerance);
        }
        if (object instanceof Complex && object2 instanceof Number) {
            return !((Complex)object).equals(new Complex((Number)object2), this.tolerance);
        }
        if (object2 instanceof Complex && object instanceof Number) {
            return !((Complex)object2).equals(new Complex((Number)object), this.tolerance);
        }
        if (object instanceof Number && object2 instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            return d3 != (d2 = ((Number)object2).doubleValue());
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = (Boolean)object;
            return bl2 != (bl = ((Boolean)object2).booleanValue());
        }
        if (object instanceof Number && object2 instanceof Boolean) {
            double d4 = ((Number)object).doubleValue();
            double d5 = (Boolean)object2 != false ? 1.0 : 0.0;
            return d4 != d5;
        }
        if (object instanceof Boolean && object2 instanceof Number) {
            double d6 = (Boolean)object != false ? 1.0 : 0.0;
            double d7 = ((Number)object2).doubleValue();
            return d6 != d7;
        }
        return !object.equals(object2);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d2) {
        this.tolerance = d2;
    }
}

