/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Divide
extends PostfixMathCommand {
    public Divide() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        Object e3 = stack.pop();
        stack.push(this.div(e3, e2));
    }

    public Object div(Object object, Object object2) throws ParseException {
        if (object instanceof Complex) {
            if (object2 instanceof Complex) {
                return this.div((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.div((Complex)object, (Number)object2);
            }
            if (object2 instanceof Vector) {
                return this.div((Complex)object, (Vector)object2);
            }
        } else if (object instanceof Number) {
            if (object2 instanceof Complex) {
                return this.div((Number)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.div((Number)object, (Number)object2);
            }
            if (object2 instanceof Vector) {
                return this.div((Number)object, (Vector)object2);
            }
        } else if (object instanceof Vector) {
            if (object2 instanceof Complex) {
                return this.div((Vector)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.div((Vector)object, (Number)object2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Double div(Number number, Number number2) {
        return new Double(number.doubleValue() / number2.doubleValue());
    }

    public Complex div(Complex complex, Complex complex2) {
        return complex.div(complex2);
    }

    public Complex div(Number number, Complex complex) {
        Complex complex2 = new Complex(number.doubleValue(), 0.0);
        return complex2.div(complex);
    }

    public Complex div(Complex complex, Number number) {
        return new Complex(complex.re() / number.doubleValue(), complex.im() / number.doubleValue());
    }

    public Vector div(Vector vector, Number number) {
        Vector<Double> vector2 = new Vector<Double>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            vector2.addElement(this.div((Number)vector.elementAt(i2), number));
        }
        return vector2;
    }

    public Vector div(Number number, Vector vector) {
        Vector<Double> vector2 = new Vector<Double>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            vector2.addElement(this.div(number, (Number)vector.elementAt(i2)));
        }
        return vector2;
    }

    public Vector div(Vector vector, Complex complex) {
        Vector<Complex> vector2 = new Vector<Complex>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            vector2.addElement(this.div((Number)vector.elementAt(i2), complex));
        }
        return vector2;
    }

    public Vector div(Complex complex, Vector vector) {
        Vector<Complex> vector2 = new Vector<Complex>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            vector2.addElement(this.div(complex, (Number)vector.elementAt(i2)));
        }
        return vector2;
    }
}

