/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Logarithm
extends PostfixMathCommand {
    private static final double LOG10 = Math.log(10.0);
    private static final Complex CLOG10 = new Complex(Math.log(10.0), 0.0);

    public Logarithm() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        stack.push(this.log(e2));
    }

    public Object log(Object object) throws ParseException {
        if (object instanceof Complex) {
            return ((Complex)object).log().div(CLOG10);
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            if (d2 >= 0.0) {
                return new Double(Math.log(d2) / LOG10);
            }
            if (d2 != d2) {
                return new Double(Double.NaN);
            }
            Complex complex = new Complex(d2);
            return complex.log().div(CLOG10);
        }
        throw new ParseException("Invalid parameter type");
    }
}

