/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class NaturalLogarithm
extends PostfixMathCommand {
    public NaturalLogarithm() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        stack.push(this.ln(e2));
    }

    public Object ln(Object object) throws ParseException {
        if (object instanceof Complex) {
            return ((Complex)object).log();
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            if (d2 >= 0.0) {
                return new Double(Math.log(d2));
            }
            if (d2 != d2) {
                return new Double(Double.NaN);
            }
            Complex complex = new Complex(d2);
            return complex.log();
        }
        throw new ParseException("Invalid parameter type");
    }
}

