/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.type;

import java.text.NumberFormat;

public class Complex {
    private double re;
    private double im;

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double d2) {
        this.re = d2;
        this.im = 0.0;
    }

    public Complex(Number number) {
        this.re = number.doubleValue();
        this.im = 0.0;
    }

    public Complex(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public Complex(double d2, double d3) {
        this.re = d2;
        this.im = d3;
    }

    public double re() {
        return this.re;
    }

    public double im() {
        return this.im;
    }

    public void set(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
    }

    public void set(double d2, double d3) {
        this.re = d2;
        this.im = d3;
    }

    public void setRe(double d2) {
        this.re = d2;
    }

    public void setIm(double d2) {
        this.im = d2;
    }

    public boolean equals(Complex complex, double d2) {
        double d3 = this.re - complex.re;
        double d4 = this.im - complex.im;
        return d3 * d3 + d4 * d4 <= d2 * d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)object;
        return Double.doubleToLongBits(this.re) == Double.doubleToLongBits(complex.re) && Double.doubleToLongBits(this.im) == Double.doubleToLongBits(complex.im);
    }

    public int hashCode() {
        int n2 = 17;
        long l2 = Double.doubleToLongBits(this.re);
        long l3 = Double.doubleToLongBits(this.im);
        int n3 = (int)(l2 ^ l2 >> 32);
        int n4 = (int)(l3 ^ l3 >> 32);
        n2 = 37 * n2 + n3;
        n2 = 37 * n2 + n4;
        return n2;
    }

    public String toString() {
        return "(" + this.re + ", " + this.im + ")";
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.re) + ", " + numberFormat.format(this.im) + ")";
    }

    public String toString(NumberFormat numberFormat, boolean bl) {
        if (this.im == 0.0) {
            return numberFormat.format(this.re);
        }
        if (this.re == 0.0) {
            return numberFormat.format(this.im) + " i)";
        }
        if (bl) {
            return "(" + numberFormat.format(this.re) + "+" + numberFormat.format(this.im) + " i)";
        }
        return numberFormat.format(this.re) + "+" + numberFormat.format(this.im) + " i";
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im);
    }

    public boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public double abs() {
        double d2 = Math.abs(this.re);
        double d3 = Math.abs(this.im);
        if (d2 == 0.0 && d3 == 0.0) {
            return 0.0;
        }
        if (d2 > d3) {
            double d4 = d3 / d2;
            return d2 * Math.sqrt(1.0 + d4 * d4);
        }
        double d5 = d2 / d3;
        return d3 * Math.sqrt(1.0 + d5 * d5);
    }

    public double abs2() {
        return this.re * this.re + this.im * this.im;
    }

    public double arg() {
        return Math.atan2(this.im, this.re);
    }

    public Complex neg() {
        return new Complex(-this.re, -this.im);
    }

    public Complex mul(double d2) {
        return new Complex(this.re * d2, this.im * d2);
    }

    public Complex add(Complex complex) {
        return new Complex(this.re + complex.re, this.im + complex.im);
    }

    public Complex sub(Complex complex) {
        return new Complex(this.re - complex.re, this.im - complex.im);
    }

    public Complex mul(Complex complex) {
        return new Complex(this.re * complex.re - this.im * complex.im, this.im * complex.re + this.re * complex.im);
    }

    public Complex div(Complex complex) {
        double d2;
        double d3;
        if (Math.abs(complex.re) >= Math.abs(complex.im)) {
            double d4 = complex.im / complex.re;
            double d5 = complex.re + d4 * complex.im;
            d3 = (this.re + d4 * this.im) / d5;
            d2 = (this.im - d4 * this.re) / d5;
        } else {
            double d6 = complex.re / complex.im;
            double d7 = complex.im + d6 * complex.re;
            d3 = (this.re * d6 + this.im) / d7;
            d2 = (this.im * d6 - this.re) / d7;
        }
        return new Complex(d3, d2);
    }

    public Complex power(double d2) {
        double d3 = Math.pow(this.abs(), d2);
        boolean bl = false;
        int n2 = 0;
        if (this.im == 0.0 && this.re < 0.0) {
            bl = true;
            n2 = 2;
        }
        if (this.re == 0.0 && this.im > 0.0) {
            bl = true;
            n2 = 1;
        }
        if (this.re == 0.0 && this.im < 0.0) {
            bl = true;
            n2 = -1;
        }
        if (bl && (double)n2 * d2 == (double)((int)((double)n2 * d2))) {
            short[] sArray = new short[]{0, 1, 0, -1};
            short[] sArray2 = new short[]{1, 0, -1, 0};
            int n3 = (int)((double)n2 * d2) % 4;
            if (n3 < 0) {
                n3 = 4 + n3;
            }
            return new Complex(d3 * (double)sArray2[n3], d3 * (double)sArray[n3]);
        }
        double d4 = d2 * this.arg();
        return new Complex(d3 * Math.cos(d4), d3 * Math.sin(d4));
    }

    public Complex power(Complex complex) {
        if (complex.im == 0.0) {
            return this.power(complex.re);
        }
        double d2 = Math.log(this.abs());
        double d3 = this.arg();
        double d4 = d2 * complex.re - d3 * complex.im;
        double d5 = d2 * complex.im + d3 * complex.re;
        double d6 = Math.exp(d4);
        return new Complex(d6 * Math.cos(d5), d6 * Math.sin(d5));
    }

    public Complex conj() {
        return new Complex(this.re, -this.im);
    }

    public Complex log() {
        return new Complex(Math.log(this.abs()), this.arg());
    }

    public Complex sqrt() {
        Complex complex;
        if (this.re == 0.0 && this.im == 0.0) {
            complex = new Complex(0.0, 0.0);
        } else {
            double d2;
            double d3;
            double d4 = Math.abs(this.re);
            if (d4 >= (d3 = Math.abs(this.im))) {
                double d5 = d3 / d4;
                d2 = Math.sqrt(d4) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + d5 * d5)));
            } else {
                double d6 = d4 / d3;
                d2 = Math.sqrt(d3) * Math.sqrt(0.5 * (d6 + Math.sqrt(1.0 + d6 * d6)));
            }
            if (this.re >= 0.0) {
                complex = new Complex(d2, this.im / (2.0 * d2));
            } else {
                if (this.im < 0.0) {
                    d2 = -d2;
                }
                complex = new Complex(this.im / (2.0 * d2), d2);
            }
        }
        return complex;
    }

    public Complex sin() {
        double d2 = -this.im;
        double d3 = this.re;
        double d4 = Math.exp(d2);
        double d5 = d4 * Math.cos(d3);
        double d6 = d4 * Math.sin(d3);
        d4 = Math.exp(-d2);
        double d7 = d4 * Math.cos(-d3);
        double d8 = d4 * Math.sin(-d3);
        return new Complex(0.5 * (d6 -= d8), -0.5 * (d5 -= d7));
    }

    public Complex cos() {
        double d2 = -this.im;
        double d3 = this.re;
        double d4 = Math.exp(d2);
        double d5 = d4 * Math.cos(d3);
        double d6 = d4 * Math.sin(d3);
        d4 = Math.exp(-d2);
        double d7 = d4 * Math.cos(-d3);
        double d8 = d4 * Math.sin(-d3);
        return new Complex(0.5 * (d5 += d7), 0.5 * (d6 += d8));
    }

    public Complex tan() {
        double d2 = -this.im;
        double d3 = this.re;
        double d4 = Math.exp(d2);
        double d5 = d4 * Math.cos(d3);
        double d6 = d4 * Math.sin(d3);
        d4 = Math.exp(-d2);
        double d7 = d4 * Math.cos(-d3);
        double d8 = d4 * Math.sin(-d3);
        Complex complex = new Complex(0.5 * (d5 -= d7), 0.5 * (d6 -= d8));
        d2 = -this.im;
        d3 = this.re;
        d4 = Math.exp(d2);
        d5 = d4 * Math.cos(d3);
        d6 = d4 * Math.sin(d3);
        d4 = Math.exp(-d2);
        d7 = d4 * Math.cos(-d3);
        d8 = d4 * Math.sin(-d3);
        Complex complex2 = new Complex(0.5 * (d5 += d7), 0.5 * (d6 += d8));
        return complex.div(complex2);
    }

    public Complex asin() {
        double d2 = 1.0 - (this.re * this.re - this.im * this.im);
        double d3 = 0.0 - (this.re * this.im + this.im * this.re);
        Complex complex = new Complex(d2, d3);
        complex = complex.sqrt();
        complex.re += -this.im;
        complex.im += this.re;
        d2 = Math.log(complex.abs());
        complex.re = d3 = complex.arg();
        complex.im = -d2;
        return complex;
    }

    public Complex acos() {
        double d2 = 1.0 - (this.re * this.re - this.im * this.im);
        double d3 = 0.0 - (this.re * this.im + this.im * this.re);
        Complex complex = new Complex(d2, d3);
        complex = complex.sqrt();
        d2 = -complex.im;
        d3 = complex.re;
        complex.re = this.re + d2;
        complex.im = this.im + d3;
        d2 = Math.log(complex.abs());
        complex.re = d3 = complex.arg();
        complex.im = -d2;
        return complex;
    }

    public Complex atan() {
        Complex complex = new Complex(-this.re, 1.0 - this.im);
        double d2 = this.re;
        double d3 = 1.0 + this.im;
        complex = complex.div(new Complex(d2, d3));
        d2 = Math.log(complex.abs());
        d3 = complex.arg();
        complex.re = 0.5 * d3;
        complex.im = -0.5 * d2;
        return complex;
    }

    public Complex sinh() {
        double d2 = Math.exp(this.re);
        double d3 = d2 * Math.cos(this.im);
        double d4 = d2 * Math.sin(this.im);
        d2 = Math.exp(-this.re);
        double d5 = d2 * Math.cos(-this.im);
        double d6 = d2 * Math.sin(-this.im);
        return new Complex(0.5 * (d3 -= d5), 0.5 * (d4 -= d6));
    }

    public Complex cosh() {
        double d2 = Math.exp(this.re);
        double d3 = d2 * Math.cos(this.im);
        double d4 = d2 * Math.sin(this.im);
        d2 = Math.exp(-this.re);
        double d5 = d2 * Math.cos(-this.im);
        double d6 = d2 * Math.sin(-this.im);
        return new Complex(0.5 * (d3 += d5), 0.5 * (d4 += d6));
    }

    public Complex tanh() {
        double d2 = Math.exp(this.re);
        double d3 = d2 * Math.cos(this.im);
        double d4 = d2 * Math.sin(this.im);
        d2 = Math.exp(-this.re);
        double d5 = d2 * Math.cos(-this.im);
        double d6 = d2 * Math.sin(-this.im);
        Complex complex = new Complex(0.5 * (d3 -= d5), 0.5 * (d4 -= d6));
        d2 = Math.exp(this.re);
        d3 = d2 * Math.cos(this.im);
        d4 = d2 * Math.sin(this.im);
        d2 = Math.exp(-this.re);
        d5 = d2 * Math.cos(-this.im);
        d6 = d2 * Math.sin(-this.im);
        Complex complex2 = new Complex(0.5 * (d3 += d5), 0.5 * (d4 += d6));
        return complex.div(complex2);
    }

    public Complex asinh() {
        Complex complex = new Complex(this.re * this.re - this.im * this.im + 1.0, this.re * this.im + this.im * this.re);
        complex = complex.sqrt();
        complex.re += this.re;
        complex.im += this.im;
        double d2 = complex.arg();
        complex.re = Math.log(complex.abs());
        complex.im = d2;
        return complex;
    }

    public Complex acosh() {
        Complex complex = new Complex(this.re * this.re - this.im * this.im - 1.0, this.re * this.im + this.im * this.re);
        complex = complex.sqrt();
        complex.re += this.re;
        complex.im += this.im;
        double d2 = complex.arg();
        complex.re = Math.log(complex.abs());
        complex.im = d2;
        return complex;
    }

    public Complex atanh() {
        Complex complex = new Complex(1.0 + this.re, this.im);
        double d2 = 1.0 - this.re;
        double d3 = -this.im;
        complex = complex.div(new Complex(d2, d3));
        d2 = Math.log(complex.abs());
        d3 = complex.arg();
        complex.re = 0.5 * d2;
        complex.im = 0.5 * d3;
        return complex;
    }

    public static Complex polarValueOf(Number number, Number number2) {
        double d2 = number.doubleValue();
        double d3 = number2.doubleValue();
        return new Complex(d2 * Math.cos(d3), d2 * Math.sin(d3));
    }

    public double doubleValue() {
        return this.re;
    }

    public float floatValue() {
        return (float)this.re;
    }

    public int intValue() {
        return (int)this.re;
    }

    public long longValue() {
        return (long)this.re;
    }
}

