/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.objectweb.asm.ByteVector;
import org.objectweb.asm.CodeWriter;
import org.objectweb.asm.Edge;

public class Label {
    CodeWriter owner;
    int line;
    boolean resolved;
    int position;
    boolean resized;
    private int referenceCount;
    private int[] srcAndRefPositions;
    int beginStackSize;
    int maxStackSize;
    Edge successors;
    Label next;
    boolean pushed;

    public int getOffset() {
        if (!this.resolved) {
            throw new IllegalStateException("Label offset position has not been resolved yet");
        }
        return this.position;
    }

    void put(CodeWriter codeWriter, ByteVector byteVector, int n2, boolean bl) {
        if (this.resolved) {
            if (bl) {
                byteVector.putInt(this.position - n2);
            } else {
                byteVector.putShort(this.position - n2);
            }
        } else if (bl) {
            this.addReference(-1 - n2, byteVector.length);
            byteVector.putInt(-1);
        } else {
            this.addReference(n2, byteVector.length);
            byteVector.putShort(-1);
        }
    }

    private void addReference(int n2, int n3) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] nArray = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, nArray, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = nArray;
        }
        this.srcAndRefPositions[this.referenceCount++] = n2;
        this.srcAndRefPositions[this.referenceCount++] = n3;
    }

    boolean resolve(CodeWriter codeWriter, int n2, byte[] byArray) {
        boolean bl = false;
        this.resolved = true;
        this.position = n2;
        int n3 = 0;
        while (n3 < this.referenceCount) {
            int n4;
            int n5 = this.srcAndRefPositions[n3++];
            int n6 = this.srcAndRefPositions[n3++];
            if (n5 >= 0) {
                n4 = n2 - n5;
                if (n4 < Short.MIN_VALUE || n4 > Short.MAX_VALUE) {
                    int n7 = byArray[n6 - 1] & 0xFF;
                    byArray[n6 - 1] = n7 <= 168 ? (byte)(n7 + 49) : (byte)(n7 + 20);
                    bl = true;
                }
                byArray[n6++] = (byte)(n4 >>> 8);
                byArray[n6] = (byte)n4;
                continue;
            }
            n4 = n2 + n5 + 1;
            byArray[n6++] = (byte)(n4 >>> 24);
            byArray[n6++] = (byte)(n4 >>> 16);
            byArray[n6++] = (byte)(n4 >>> 8);
            byArray[n6] = (byte)n4;
        }
        return bl;
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

