/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;

public class SourceDebugExtensionAttribute
extends Attribute {
    public String debugExtension;

    public SourceDebugExtensionAttribute() {
        super("SourceDebugExtension");
    }

    public SourceDebugExtensionAttribute(String string) {
        this();
        this.debugExtension = string;
    }

    protected Attribute read(ClassReader classReader, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        return new SourceDebugExtensionAttribute(this.readUTF8(classReader, n2, n3));
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n2, int n3, int n4) {
        byte[] byArray2 = this.putUTF8(this.debugExtension);
        return new ByteVector().putByteArray(byArray2, 0, byArray2.length);
    }

    private String readUTF8(ClassReader classReader, int n2, int n3) {
        int n4 = n2 + n3;
        byte[] byArray = classReader.b;
        char[] cArray = new char[n3];
        int n5 = 0;
        block4: while (n2 < n4) {
            byte by;
            int n6 = byArray[n2++] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)n6;
                    continue block4;
                }
                case 12: 
                case 13: {
                    by = byArray[n2++];
                    cArray[n5++] = (char)((n6 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
            }
            by = byArray[n2++];
            byte by2 = byArray[n2++];
            cArray[n5++] = (char)((n6 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
        }
        return new String(cArray, 0, n5);
    }

    private byte[] putUTF8(String string) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = string.charAt(i2);
            if (n2 >= 1 && n2 <= 127) {
                ++n4;
                continue;
            }
            if (n2 > 2047) {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        byte[] byArray = new byte[n4];
        n2 = 0;
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                byArray[n2++] = (byte)c2;
                continue;
            }
            if (c2 > '\u07ff') {
                byArray[n2++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
            byArray[n2++] = (byte)(0x80 | c2 & 0x3F);
        }
        return byArray;
    }

    public String toString() {
        return this.debugExtension;
    }
}

