/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.ArrayList;
import java.util.HashSet;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.StackMapFrame;

public class StackMapAttribute
extends Attribute {
    static final int MAX_SIZE = 65535;
    public ArrayList frames = new ArrayList();

    public StackMapAttribute() {
        super("StackMap");
    }

    public StackMapFrame getFrame(Label label) {
        for (int i2 = 0; i2 < this.frames.size(); ++i2) {
            StackMapFrame stackMapFrame = (StackMapFrame)this.frames.get(i2);
            if (stackMapFrame.label != label) continue;
            return stackMapFrame;
        }
        return null;
    }

    protected Attribute read(ClassReader classReader, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        StackMapAttribute stackMapAttribute = new StackMapAttribute();
        int n5 = classReader.readInt(n4 + 4);
        int n6 = 0;
        if (n5 > 65535) {
            n6 = classReader.readInt(n2);
            n2 += 4;
        } else {
            n6 = classReader.readShort(n2);
            n2 += 2;
        }
        for (int i2 = 0; i2 < n6; ++i2) {
            StackMapFrame stackMapFrame = new StackMapFrame();
            n2 = stackMapFrame.read(classReader, n2, cArray, n4, labelArray);
            stackMapAttribute.frames.add(stackMapFrame);
        }
        return stackMapAttribute;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n2, int n3, int n4) {
        ByteVector byteVector = new ByteVector();
        if (byArray != null && byArray.length > 65535) {
            byteVector.putInt(this.frames.size());
        } else {
            byteVector.putShort(this.frames.size());
        }
        for (int i2 = 0; i2 < this.frames.size(); ++i2) {
            ((StackMapFrame)this.frames.get(i2)).write(classWriter, n3, n4, byteVector);
        }
        return byteVector;
    }

    protected Label[] getLabels() {
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < this.frames.size(); ++i2) {
            ((StackMapFrame)this.frames.get(i2)).getLabels(hashSet);
        }
        return hashSet.toArray(new Label[hashSet.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StackMap[");
        for (int i2 = 0; i2 < this.frames.size(); ++i2) {
            stringBuffer.append('\n').append('[').append(this.frames.get(i2)).append(']');
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

