/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v2;

import java.util.Vector;
import org.postgresql.core.ParameterList;
import org.postgresql.core.Query;
import org.postgresql.core.v2.SimpleParameterList;

class V2Query
implements Query {
    private static final ParameterList NO_PARAMETERS = new SimpleParameterList(0);
    private final String[] fragments;

    V2Query(String query, boolean withParameters) {
        if (!withParameters) {
            this.fragments = new String[]{query};
            return;
        }
        Vector<String> v = new Vector<String>();
        int lastParmEnd = 0;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        int i2 = 0;
        while (i2 < query.length()) {
            char c2 = query.charAt(i2);
            switch (c2) {
                case '\\': {
                    if (!inSingleQuotes) break;
                    ++i2;
                    break;
                }
                case '\'': {
                    inSingleQuotes = !inDoubleQuotes && !inSingleQuotes;
                    break;
                }
                case '\"': {
                    inDoubleQuotes = !inSingleQuotes && !inDoubleQuotes;
                    break;
                }
                case '?': {
                    if (inSingleQuotes || inDoubleQuotes) break;
                    v.addElement(query.substring(lastParmEnd, i2));
                    lastParmEnd = i2 + 1;
                    break;
                }
            }
            ++i2;
        }
        v.addElement(query.substring(lastParmEnd, query.length()));
        this.fragments = new String[v.size()];
        int i3 = 0;
        while (i3 < this.fragments.length) {
            this.fragments[i3] = (String)v.elementAt(i3);
            ++i3;
        }
    }

    public void close() {
    }

    public ParameterList createParameterList() {
        if (this.fragments.length == 1) {
            return NO_PARAMETERS;
        }
        return new SimpleParameterList(this.fragments.length - 1);
    }

    String[] getFragments() {
        return this.fragments;
    }

    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.fragments[0]);
        int i2 = 1;
        while (i2 < this.fragments.length) {
            if (parameters == null) {
                sbuf.append("?");
            } else {
                sbuf.append(parameters.toString(i2));
            }
            sbuf.append(this.fragments[i2]);
            ++i2;
        }
        return sbuf.toString();
    }
}

