/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;

class CSharpCharFormatter
implements CharFormatter {
    CSharpCharFormatter() {
    }

    public String escapeChar(int n2, boolean bl) {
        switch (n2) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return bl ? "\\'" : "'";
            }
            case 34: {
                return bl ? "\"" : "\\\"";
            }
        }
        if (n2 < 32 || n2 > 126) {
            if (0 <= n2 && n2 <= 15) {
                return "\\u000" + Integer.toString(n2, 16);
            }
            if (16 <= n2 && n2 <= 255) {
                return "\\u00" + Integer.toString(n2, 16);
            }
            if (256 <= n2 && n2 <= 4095) {
                return "\\u0" + Integer.toString(n2, 16);
            }
            return "\\u" + Integer.toString(n2, 16);
        }
        return String.valueOf((char)n2);
    }

    public String escapeString(String string) {
        String string2 = new String();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            string2 = string2 + this.escapeChar(string.charAt(i2), false);
        }
        return string2;
    }

    public String literalChar(int n2) {
        return "'" + this.escapeChar(n2, true) + "'";
    }

    public String literalString(String string) {
        return "@\"\"\"" + this.escapeString(string) + "\"\"\"";
    }
}

