/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenWithIndex;
import antlr.collections.impl.BitSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TokenStreamRewriteEngine
implements TokenStream {
    public static final int MIN_TOKEN_INDEX = 0;
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    protected List tokens;
    protected Map programs = null;
    protected Map lastRewriteTokenIndexes = null;
    protected int index = 0;
    protected TokenStream stream;
    protected BitSet discardMask = new BitSet();

    public TokenStreamRewriteEngine(TokenStream tokenStream) {
        this(tokenStream, 1000);
    }

    public TokenStreamRewriteEngine(TokenStream tokenStream, int n2) {
        this.stream = tokenStream;
        this.tokens = new ArrayList(n2);
        this.programs = new HashMap();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap();
    }

    public Token nextToken() throws TokenStreamException {
        TokenWithIndex tokenWithIndex;
        do {
            if ((tokenWithIndex = (TokenWithIndex)this.stream.nextToken()) == null) continue;
            tokenWithIndex.setIndex(this.index);
            if (tokenWithIndex.getType() != 1) {
                this.tokens.add(tokenWithIndex);
            }
            ++this.index;
        } while (tokenWithIndex != null && this.discardMask.member(tokenWithIndex.getType()));
        return tokenWithIndex;
    }

    public void rollback(int n2) {
        this.rollback(DEFAULT_PROGRAM_NAME, n2);
    }

    public void rollback(String string, int n2) {
        List list = (List)this.programs.get(string);
        if (list != null) {
            this.programs.put(string, list.subList(0, n2));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String string) {
        this.rollback(string, 0);
    }

    protected void addToSortedRewriteList(RewriteOperation rewriteOperation) {
        this.addToSortedRewriteList(DEFAULT_PROGRAM_NAME, rewriteOperation);
    }

    protected void addToSortedRewriteList(String string, RewriteOperation rewriteOperation) {
        List list = this.getProgram(string);
        if (rewriteOperation.index >= this.getLastRewriteTokenIndex(string)) {
            list.add(rewriteOperation);
            this.setLastRewriteTokenIndex(string, rewriteOperation.index);
            return;
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                RewriteOperation rewriteOperation = (RewriteOperation)object;
                RewriteOperation rewriteOperation2 = (RewriteOperation)object2;
                if (rewriteOperation.index < rewriteOperation2.index) {
                    return -1;
                }
                if (rewriteOperation.index > rewriteOperation2.index) {
                    return 1;
                }
                return 0;
            }
        };
        int n2 = Collections.binarySearch(list, rewriteOperation, comparator);
        if (n2 < 0) {
            list.add(-n2 - 1, rewriteOperation);
        }
    }

    public void insertAfter(Token token, String string) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, token, string);
    }

    public void insertAfter(int n2, String string) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, n2, string);
    }

    public void insertAfter(String string, Token token, String string2) {
        this.insertAfter(string, ((TokenWithIndex)token).getIndex(), string2);
    }

    public void insertAfter(String string, int n2, String string2) {
        this.insertBefore(string, n2 + 1, string2);
    }

    public void insertBefore(Token token, String string) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, token, string);
    }

    public void insertBefore(int n2, String string) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, n2, string);
    }

    public void insertBefore(String string, Token token, String string2) {
        this.insertBefore(string, ((TokenWithIndex)token).getIndex(), string2);
    }

    public void insertBefore(String string, int n2, String string2) {
        this.addToSortedRewriteList(string, new InsertBeforeOp(n2, string2));
    }

    public void replace(int n2, String string) {
        this.replace(DEFAULT_PROGRAM_NAME, n2, n2, string);
    }

    public void replace(int n2, int n3, String string) {
        this.replace(DEFAULT_PROGRAM_NAME, n2, n3, string);
    }

    public void replace(Token token, String string) {
        this.replace(DEFAULT_PROGRAM_NAME, token, token, string);
    }

    public void replace(Token token, Token token2, String string) {
        this.replace(DEFAULT_PROGRAM_NAME, token, token2, string);
    }

    public void replace(String string, int n2, int n3, String string2) {
        this.addToSortedRewriteList(new ReplaceOp(n2, n3, string2));
    }

    public void replace(String string, Token token, Token token2, String string2) {
        this.replace(string, ((TokenWithIndex)token).getIndex(), ((TokenWithIndex)token2).getIndex(), string2);
    }

    public void delete(int n2) {
        this.delete(DEFAULT_PROGRAM_NAME, n2, n2);
    }

    public void delete(int n2, int n3) {
        this.delete(DEFAULT_PROGRAM_NAME, n2, n3);
    }

    public void delete(Token token) {
        this.delete(DEFAULT_PROGRAM_NAME, token, token);
    }

    public void delete(Token token, Token token2) {
        this.delete(DEFAULT_PROGRAM_NAME, token, token2);
    }

    public void delete(String string, int n2, int n3) {
        this.replace(string, n2, n3, null);
    }

    public void delete(String string, Token token, Token token2) {
        this.replace(string, token, token2, null);
    }

    public void discard(int n2) {
        this.discardMask.add(n2);
    }

    public TokenWithIndex getToken(int n2) {
        return (TokenWithIndex)this.tokens.get(n2);
    }

    public int getTokenStreamSize() {
        return this.tokens.size();
    }

    public String toOriginalString() {
        return this.toOriginalString(0, this.getTokenStreamSize() - 1);
    }

    public String toOriginalString(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = n2; i2 >= 0 && i2 <= n3 && i2 < this.tokens.size(); ++i2) {
            stringBuffer.append(this.getToken(i2).getText());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0, this.getTokenStreamSize());
    }

    public String toString(String string) {
        return this.toString(string, 0, this.getTokenStreamSize());
    }

    public String toString(int n2, int n3) {
        return this.toString(DEFAULT_PROGRAM_NAME, n2, n3);
    }

    public String toString(String string, int n2, int n3) {
        List list = (List)this.programs.get(string);
        if (list == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        int n5 = n2;
        while (n5 >= 0 && n5 <= n3 && n5 < this.tokens.size()) {
            if (n4 < list.size()) {
                RewriteOperation rewriteOperation = (RewriteOperation)list.get(n4);
                while (n5 == rewriteOperation.index && n4 < list.size()) {
                    n5 = rewriteOperation.execute(stringBuffer);
                    if (++n4 >= list.size()) continue;
                    rewriteOperation = (RewriteOperation)list.get(n4);
                }
            }
            if (n5 >= n3) continue;
            stringBuffer.append(this.getToken(n5).getText());
            ++n5;
        }
        for (int i2 = n4; i2 < list.size(); ++i2) {
            RewriteOperation rewriteOperation = (RewriteOperation)list.get(i2);
            rewriteOperation.execute(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        return this.toDebugString(0, this.getTokenStreamSize());
    }

    public String toDebugString(int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = n2; i2 >= 0 && i2 <= n3 && i2 < this.tokens.size(); ++i2) {
            stringBuffer.append(this.getToken(i2));
        }
        return stringBuffer.toString();
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String string) {
        Integer n2 = (Integer)this.lastRewriteTokenIndexes.get(string);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    protected void setLastRewriteTokenIndex(String string, int n2) {
        this.lastRewriteTokenIndexes.put(string, new Integer(n2));
    }

    protected List getProgram(String string) {
        List list = (List)this.programs.get(string);
        if (list == null) {
            list = this.initializeProgram(string);
        }
        return list;
    }

    private List initializeProgram(String string) {
        ArrayList arrayList = new ArrayList(100);
        this.programs.put(string, arrayList);
        return arrayList;
    }

    static class DeleteOp
    extends ReplaceOp {
        public DeleteOp(int n2, int n3) {
            super(n2, n3, null);
        }
    }

    static class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int n2, int n3, String string) {
            super(n2, string);
            this.lastIndex = n3;
        }

        public int execute(StringBuffer stringBuffer) {
            if (this.text != null) {
                stringBuffer.append(this.text);
            }
            return this.lastIndex + 1;
        }
    }

    static class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int n2, String string) {
            super(n2, string);
        }

        public int execute(StringBuffer stringBuffer) {
            stringBuffer.append(this.text);
            return this.index;
        }
    }

    static class RewriteOperation {
        protected int index;
        protected String text;

        protected RewriteOperation(int n2, String string) {
            this.index = n2;
            this.text = string;
        }

        public int execute(StringBuffer stringBuffer) {
            return this.index;
        }
    }
}

