/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1OutputStream;
import com.lowagie.bc.asn1.ASN1Sequence;
import com.lowagie.bc.asn1.ASN1Set;
import com.lowagie.bc.asn1.BERConstructedOctetString;
import com.lowagie.bc.asn1.BERConstructedSequence;
import com.lowagie.bc.asn1.BEROutputStream;
import com.lowagie.bc.asn1.DEREncodable;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERTaggedObject;
import java.io.IOException;
import java.util.Enumeration;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int tagNo, DEREncodable obj) {
        super(tagNo, obj);
    }

    public BERTaggedObject(boolean explicit, int tagNo, DEREncodable obj) {
        super(explicit, tagNo, obj);
    }

    public BERTaggedObject(int tagNo) {
        super(false, tagNo, new BERConstructedSequence());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void encode(DEROutputStream out) throws IOException {
        if (out instanceof ASN1OutputStream || out instanceof BEROutputStream) {
            out.write(0xA0 | this.tagNo);
            out.write(128);
            if (!this.empty) {
                if (!this.explicit) {
                    if (this.obj instanceof ASN1OctetString) {
                        Enumeration e2;
                        if (this.obj instanceof BERConstructedOctetString) {
                            e2 = ((BERConstructedOctetString)this.obj).getObjects();
                        } else {
                            ASN1OctetString octs = (ASN1OctetString)this.obj;
                            BERConstructedOctetString berO = new BERConstructedOctetString(octs.getOctets());
                            e2 = berO.getObjects();
                        }
                        while (e2.hasMoreElements()) {
                            out.writeObject(e2.nextElement());
                        }
                    } else if (this.obj instanceof ASN1Sequence) {
                        Enumeration e3 = ((ASN1Sequence)this.obj).getObjects();
                        while (e3.hasMoreElements()) {
                            out.writeObject(e3.nextElement());
                        }
                    } else {
                        if (!(this.obj instanceof ASN1Set)) throw new RuntimeException("not implemented: " + this.obj.getClass().getName());
                        Enumeration e4 = ((ASN1Set)this.obj).getObjects();
                        while (e4.hasMoreElements()) {
                            out.writeObject(e4.nextElement());
                        }
                    }
                } else {
                    out.writeObject(this.obj);
                }
            }
            out.write(0);
            out.write(0);
            return;
        } else {
            super.encode(out);
        }
    }
}

